/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.impl.factory.Sets;
import org.neo4j.common.DependencyResolver;
import org.neo4j.common.EmptyDependencyResolver;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Header;
import org.neo4j.index.internal.gbptree.KeyLayout;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.LoggingStructureWriteLog;
import org.neo4j.index.internal.gbptree.MultiRootGBPTree;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.index.internal.gbptree.RootLayerConfiguration;
import org.neo4j.index.internal.gbptree.StructureWriteLog;
import org.neo4j.index.internal.gbptree.TreeNodeLayoutFactory;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.context.FixedVersionContextSupplier;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;

public class GBPTreeBuilder<ROOT_KEY, KEY, VALUE> {
    private final PageCache pageCache;
    private FileSystemAbstraction fileSystem;
    private Path path;
    private MultiRootGBPTree.Monitor monitor = GBPTree.NO_MONITOR;
    private Header.Reader headerReader = GBPTree.NO_HEADER_READER;
    private Layout<KEY, VALUE> dataLayout;
    private KeyLayout<ROOT_KEY> rootLayout;
    private RecoveryCleanupWorkCollector recoveryCleanupWorkCollector = RecoveryCleanupWorkCollector.immediate();
    private boolean readOnly;
    private PageCacheTracer pageCacheTracer = PageCacheTracer.NULL;
    private ImmutableSet<OpenOption> openOptions = Sets.immutable.empty();
    private TreeNodeLayoutFactory treeNodeLayoutFactory = TreeNodeLayoutFactory.getInstance();
    private DependencyResolver dependencyResolver = EmptyDependencyResolver.EMPTY_RESOLVER;

    public GBPTreeBuilder(PageCache pageCache, FileSystemAbstraction fileSystem, Path path, Layout<KEY, VALUE> dataLayout) {
        this.pageCache = pageCache;
        this.with(fileSystem);
        this.with(path);
        this.with(dataLayout);
    }

    public GBPTreeBuilder(PageCache pageCache, FileSystemAbstraction fileSystem, Path path, Layout<KEY, VALUE> dataLayout, KeyLayout<ROOT_KEY> rootLayout) {
        this.pageCache = pageCache;
        this.with(fileSystem);
        this.with(path);
        this.with(dataLayout);
        this.withRootLayout(rootLayout);
        this.treeNodeLayoutFactory = TreeNodeLayoutFactory.getInstance();
    }

    public GBPTreeBuilder<ROOT_KEY, KEY, VALUE> with(FileSystemAbstraction fileSystem) {
        this.fileSystem = fileSystem;
        return this;
    }

    public GBPTreeBuilder<ROOT_KEY, KEY, VALUE> with(Layout<KEY, VALUE> layout) {
        this.dataLayout = layout;
        return this;
    }

    public GBPTreeBuilder<ROOT_KEY, KEY, VALUE> withRootLayout(KeyLayout<ROOT_KEY> layout) {
        this.rootLayout = layout;
        return this;
    }

    public GBPTreeBuilder<ROOT_KEY, KEY, VALUE> with(Path file) {
        this.path = file;
        return this;
    }

    public GBPTreeBuilder<ROOT_KEY, KEY, VALUE> with(MultiRootGBPTree.Monitor monitor) {
        this.monitor = monitor;
        return this;
    }

    public GBPTreeBuilder<ROOT_KEY, KEY, VALUE> with(Header.Reader headerReader) {
        this.headerReader = headerReader;
        return this;
    }

    public GBPTreeBuilder<ROOT_KEY, KEY, VALUE> with(RecoveryCleanupWorkCollector recoveryCleanupWorkCollector) {
        this.recoveryCleanupWorkCollector = recoveryCleanupWorkCollector;
        return this;
    }

    public GBPTreeBuilder<ROOT_KEY, KEY, VALUE> readOnly() {
        this.readOnly = true;
        return this;
    }

    public GBPTreeBuilder<ROOT_KEY, KEY, VALUE> with(PageCacheTracer pageCacheTracer) {
        this.pageCacheTracer = pageCacheTracer;
        return this;
    }

    public GBPTreeBuilder<ROOT_KEY, KEY, VALUE> with(ImmutableSet<OpenOption> openOptions) {
        this.openOptions = openOptions;
        return this;
    }

    public GBPTreeBuilder<ROOT_KEY, KEY, VALUE> with(DependencyResolver dependencyResolver) {
        this.dependencyResolver = dependencyResolver;
        return this;
    }

    public GBPTreeBuilder<ROOT_KEY, KEY, VALUE> with(TreeNodeLayoutFactory treeNodeLayoutFactory) {
        this.treeNodeLayoutFactory = treeNodeLayoutFactory;
        return this;
    }

    public GBPTree<KEY, VALUE> build() {
        CursorContextFactory cursorContextFactory = new CursorContextFactory(this.pageCacheTracer, FixedVersionContextSupplier.EMPTY_CONTEXT_SUPPLIER);
        return new GBPTree(this.pageCache, this.fileSystem, this.path, this.dataLayout, this.monitor, this.headerReader, this.recoveryCleanupWorkCollector, this.readOnly, this.openOptions, "neo4j", "test tree", cursorContextFactory, this.pageCacheTracer, this.dependencyResolver, this.treeNodeLayoutFactory, (StructureWriteLog)LoggingStructureWriteLog.forGBPTree((FileSystemAbstraction)this.fileSystem, (Path)this.path));
    }

    public MultiRootGBPTree<ROOT_KEY, KEY, VALUE> buildMultiRoot() {
        CursorContextFactory cursorContextFactory = new CursorContextFactory(this.pageCacheTracer, FixedVersionContextSupplier.EMPTY_CONTEXT_SUPPLIER);
        return new MultiRootGBPTree(this.pageCache, this.fileSystem, this.path, this.dataLayout, this.monitor, this.headerReader, this.recoveryCleanupWorkCollector, this.readOnly, this.openOptions, "neo4j", "test tree", cursorContextFactory, RootLayerConfiguration.multipleRoots(this.rootLayout, (int)((int)ByteUnit.kibiBytes((long)10L))), this.pageCacheTracer, this.dependencyResolver, this.treeNodeLayoutFactory, (StructureWriteLog)LoggingStructureWriteLog.forGBPTree((FileSystemAbstraction)this.fileSystem, (Path)this.path));
    }
}

