/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.io.pagecache.ByteArrayPageCursor;
import org.neo4j.io.pagecache.CursorException;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;

class PageAwareByteArrayCursor
extends PageCursor {
    private final int payloadSize;
    private final List<byte[]> pages;
    private PageCursor current;
    private long currentPageId = -1L;
    private long nextPageId;
    private PageAwareByteArrayCursor linkedCursor;
    private boolean shouldRetry;
    private int closeCount;

    PageAwareByteArrayCursor(int payloadSize) {
        this(payloadSize, 0L);
    }

    private PageAwareByteArrayCursor(int payloadSize, long nextPageId) {
        this(new ArrayList<byte[]>(), payloadSize, nextPageId);
    }

    private PageAwareByteArrayCursor(List<byte[]> pages, int payloadSize, long nextPageId) {
        this.pages = pages;
        this.payloadSize = payloadSize;
        this.nextPageId = nextPageId;
        this.initialize();
    }

    private void initialize() {
        this.currentPageId = -1L;
        this.current = null;
    }

    PageAwareByteArrayCursor duplicate() {
        return new PageAwareByteArrayCursor(this.pages, this.payloadSize, this.currentPageId);
    }

    PageAwareByteArrayCursor duplicate(long nextPageId) {
        return new PageAwareByteArrayCursor(this.pages, this.payloadSize, nextPageId);
    }

    void forceRetry() {
        this.shouldRetry = true;
    }

    public long getCurrentPageId() {
        return this.currentPageId;
    }

    public boolean next() {
        this.currentPageId = this.nextPageId++;
        this.assertPages();
        byte[] page = this.page(this.currentPageId);
        this.current = ByteArrayPageCursor.wrap((byte[])page, (int)0, (int)page.length, (long)this.currentPageId);
        return true;
    }

    public boolean next(long pageId) {
        this.currentPageId = pageId;
        this.assertPages();
        byte[] page = this.page(this.currentPageId);
        this.current = ByteArrayPageCursor.wrap((byte[])page, (int)0, (int)page.length);
        return true;
    }

    public int copyTo(int sourceOffset, PageCursor targetCursor, int targetOffset, int lengthInBytes) {
        if (sourceOffset < 0 || targetOffset < 0 || lengthInBytes < 0) {
            throw new IllegalArgumentException(String.format("sourceOffset=%d, targetOffset=%d, lengthInBytes=%d, currentPageId=%d", sourceOffset, targetOffset, lengthInBytes, this.currentPageId));
        }
        int bytesToCopy = Math.min(lengthInBytes, Math.min(this.current.getPagedFile().payloadSize() - sourceOffset, targetCursor.getPagedFile().payloadSize() - targetOffset));
        byte[] bytes = new byte[bytesToCopy];
        this.setOffset(sourceOffset);
        this.getBytes(bytes);
        targetCursor.setOffset(targetOffset);
        targetCursor.putBytes(bytes);
        return bytesToCopy;
    }

    public void copyPage(PageCursor targetCursor) {
        throw new UnsupportedOperationException();
    }

    public int copyTo(int sourceOffset, ByteBuffer buf) {
        int bytesToCopy = Math.min(buf.limit() - buf.position(), this.payloadSize - sourceOffset);
        for (int i = 0; i < bytesToCopy; ++i) {
            byte b = this.getByte(sourceOffset + i);
            buf.put(b);
        }
        return bytesToCopy;
    }

    public int copyFrom(ByteBuffer sourceBuffer, int targetOffset) {
        int bytesToCopy = Math.min(sourceBuffer.limit() - sourceBuffer.position(), this.payloadSize - targetOffset);
        for (int i = 0; i < bytesToCopy; ++i) {
            byte b = sourceBuffer.get();
            this.putByte(targetOffset + i, b);
        }
        return bytesToCopy;
    }

    public void shiftBytes(int sourceOffset, int length, int shift) {
        this.current.shiftBytes(sourceOffset, length, shift);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertPages() {
        if (this.currentPageId >= (long)this.pages.size()) {
            List<byte[]> list = this.pages;
            synchronized (list) {
                int i = this.pages.size();
                while ((long)i <= this.currentPageId) {
                    this.pages.add(new byte[this.payloadSize]);
                    ++i;
                }
            }
        }
    }

    private byte[] page(long pageId) {
        return this.pages.get((int)pageId);
    }

    public Path getCurrentFile() {
        return this.current.getCurrentFile();
    }

    public PagedFile getPagedFile() {
        return this.current.getPagedFile();
    }

    public Path getRawCurrentFile() {
        return this.current.getRawCurrentFile();
    }

    public byte getByte() {
        return this.current.getByte();
    }

    public byte getByte(int offset) {
        return this.current.getByte(offset);
    }

    public void putByte(byte value) {
        this.current.putByte(value);
    }

    public void putByte(int offset, byte value) {
        this.current.putByte(offset, value);
    }

    public long getLong() {
        return this.current.getLong();
    }

    public long getLong(int offset) {
        return this.current.getLong(offset);
    }

    public void putLong(long value) {
        this.current.putLong(value);
    }

    public void putLong(int offset, long value) {
        this.current.putLong(offset, value);
    }

    public int getInt() {
        return this.current.getInt();
    }

    public int getInt(int offset) {
        return this.current.getInt(offset);
    }

    public void putInt(int value) {
        this.current.putInt(value);
    }

    public void putInt(int offset, int value) {
        this.current.putInt(offset, value);
    }

    public void getBytes(byte[] data) {
        this.current.getBytes(data);
    }

    public void getBytes(byte[] data, int arrayOffset, int length) {
        this.current.getBytes(data, arrayOffset, length);
    }

    public void putBytes(byte[] data) {
        this.current.putBytes(data);
    }

    public void putBytes(byte[] data, int arrayOffset, int length) {
        this.current.putBytes(data, arrayOffset, length);
    }

    public void putBytes(int bytes, byte value) {
        this.current.putBytes(bytes, value);
    }

    public short getShort() {
        return this.current.getShort();
    }

    public short getShort(int offset) {
        return this.current.getShort(offset);
    }

    public void putShort(short value) {
        this.current.putShort(value);
    }

    public void putShort(int offset, short value) {
        this.current.putShort(offset, value);
    }

    public void setOffset(int offset) {
        this.current.setOffset(offset);
    }

    public int getOffset() {
        return this.current.getOffset();
    }

    public void mark() {
        this.current.mark();
    }

    public void setOffsetToMark() {
        this.current.setOffsetToMark();
    }

    public void close() {
        ++this.closeCount;
        if (this.linkedCursor != null) {
            this.linkedCursor.close();
        }
        if (this.current != null) {
            this.current.close();
        }
    }

    public boolean shouldRetry() throws IOException {
        if (this.shouldRetry) {
            this.shouldRetry = false;
            if (this.linkedCursor != null) {
                this.linkedCursor.shouldRetry();
            }
            return true;
        }
        return this.linkedCursor != null && this.linkedCursor.shouldRetry() || this.current.shouldRetry();
    }

    public boolean checkAndClearBoundsFlag() {
        boolean result = false;
        if (this.linkedCursor != null) {
            result = this.linkedCursor.checkAndClearBoundsFlag();
        }
        return result |= this.current.checkAndClearBoundsFlag();
    }

    public void checkAndClearCursorException() throws CursorException {
        this.current.checkAndClearCursorException();
    }

    public void setCursorException(String message) {
        this.current.setCursorException(message);
    }

    public void clearCursorException() {
        this.current.clearCursorException();
    }

    public PageCursor openLinkedCursor(long pageId) {
        if (this.linkedCursor != null && this.linkedCursor.closeCount == 0) {
            throw new IllegalStateException("Previously created linked PageAwareByteArrayCursor still in use");
        }
        this.linkedCursor = new PageAwareByteArrayCursor(this.pages, this.payloadSize, pageId);
        return this.linkedCursor;
    }

    public void zapPage() {
        this.current.zapPage();
    }

    public boolean isWriteLocked() {
        return this.current == null || this.current.isWriteLocked();
    }

    public void setPageHorizon(long horizon) {
        throw new UnsupportedOperationException();
    }

    public void unpin() {
    }

    public ByteOrder getByteOrder() {
        return this.current.getByteOrder();
    }

    public int getCloseCount() {
        return this.closeCount;
    }
}

