/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.IOException;
import java.nio.file.OpenOption;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.collections.api.set.ImmutableSet;
import org.neo4j.index.internal.gbptree.GBPTreeConsistencyCheckVisitor;
import org.neo4j.index.internal.gbptree.MultiRootGBPTree;
import org.neo4j.index.internal.gbptree.ThrowingConsistencyCheckVisitor;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContextFactory;

class GBPTreeTestUtil {
    GBPTreeTestUtil() {
    }

    static <KEY> boolean contains(List<KEY> expectedKeys, KEY key, Comparator<KEY> comparator) {
        return expectedKeys.stream().map(GBPTreeTestUtil.bind(comparator::compare, key)).anyMatch(Predicate.isEqual(0));
    }

    private static <T, U, R> Function<U, R> bind(BiFunction<T, U, R> f, T t) {
        return u -> f.apply(t, u);
    }

    static int calculatePayloadSize(PageCache pageCache, ImmutableSet<OpenOption> openOptions) {
        int reservedBytes = pageCache.pageReservedBytes(openOptions);
        return pageCache.pageSize() - reservedBytes;
    }

    static boolean consistencyCheckStrict(MultiRootGBPTree<?, ?, ?> tree) throws IOException {
        return tree.consistencyCheck((GBPTreeConsistencyCheckVisitor)new ThrowingConsistencyCheckVisitor(), true, CursorContextFactory.NULL_CONTEXT_FACTORY, Runtime.getRuntime().availableProcessors(), ProgressMonitorFactory.NONE);
    }

    static boolean consistencyCheck(MultiRootGBPTree<?, ?, ?> tree, GBPTreeConsistencyCheckVisitor visitor) {
        return GBPTreeTestUtil.consistencyCheck(tree, visitor, Runtime.getRuntime().availableProcessors());
    }

    static boolean consistencyCheck(MultiRootGBPTree<?, ?, ?> tree, GBPTreeConsistencyCheckVisitor visitor, int numThreads) {
        return tree.consistencyCheck(visitor, true, CursorContextFactory.NULL_CONTEXT_FACTORY, numThreads, ProgressMonitorFactory.NONE);
    }
}

