/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.util.Arrays;
import java.util.StringJoiner;
import org.apache.commons.lang3.ArrayUtils;

public class RawBytes {
    static final RawBytes EMPTY_BYTES = new RawBytes(ArrayUtils.EMPTY_BYTE_ARRAY);
    byte[] bytes;

    public RawBytes() {
        this(ArrayUtils.EMPTY_BYTE_ARRAY);
    }

    public RawBytes(byte[] byteArray) {
        this.bytes = byteArray;
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(", ", "[", "]");
        int nbrOfAccumulatedZeroes = 0;
        for (int index = 0; index < this.bytes.length; ++index) {
            if (this.bytes[index] != 0) {
                if (nbrOfAccumulatedZeroes > 0) {
                    joiner.add(RawBytes.replaceZeroes(nbrOfAccumulatedZeroes));
                    nbrOfAccumulatedZeroes = 0;
                }
                joiner.add(Byte.toString(this.bytes[index]));
                continue;
            }
            ++nbrOfAccumulatedZeroes;
        }
        if (nbrOfAccumulatedZeroes > 0) {
            joiner.add(RawBytes.replaceZeroes(nbrOfAccumulatedZeroes));
        }
        return joiner.toString();
    }

    private static String replaceZeroes(int nbrOfZeroes) {
        if (nbrOfZeroes > 3) {
            return "0...>" + nbrOfZeroes;
        }
        StringJoiner joiner = new StringJoiner(", ");
        for (int i = 0; i < nbrOfZeroes; ++i) {
            joiner.add("0");
        }
        return joiner.toString();
    }

    void copyFrom(RawBytes source) {
        this.bytes = Arrays.copyOf(source.bytes, source.bytes.length);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RawBytes rawBytes = (RawBytes)o;
        return Arrays.equals(this.bytes, rawBytes.bytes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }
}

