/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.function.Consumer;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.impl.factory.Sets;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Header;
import org.neo4j.index.internal.gbptree.KeyLayout;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.MultiRootGBPTree;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.index.internal.gbptree.RootLayerConfiguration;
import org.neo4j.index.internal.gbptree.TreeNodeLayoutFactory;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.context.EmptyVersionContextSupplier;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;

public class GBPTreeBuilder<ROOT_KEY, KEY, VALUE> {
    private final PageCache pageCache;
    private final FileSystemAbstraction fileSystem;
    private Path path;
    private MultiRootGBPTree.Monitor monitor = GBPTree.NO_MONITOR;
    private Header.Reader headerReader = GBPTree.NO_HEADER_READER;
    private Layout<KEY, VALUE> dataLayout;
    private KeyLayout<ROOT_KEY> rootLayout;
    private Consumer<PageCursor> headerWriter = GBPTree.NO_HEADER_WRITER;
    private RecoveryCleanupWorkCollector recoveryCleanupWorkCollector = RecoveryCleanupWorkCollector.immediate();
    private DatabaseReadOnlyChecker readOnlyChecker = DatabaseReadOnlyChecker.writable();
    private PageCacheTracer pageCacheTracer = PageCacheTracer.NULL;
    private ImmutableSet<OpenOption> openOptions = Sets.immutable.empty();
    private TreeNodeLayoutFactory treeNodeLayoutFactory = TreeNodeLayoutFactory.getInstance();

    public GBPTreeBuilder(PageCache pageCache, FileSystemAbstraction fileSystem, Path path, Layout<KEY, VALUE> dataLayout) {
        this.pageCache = pageCache;
        this.fileSystem = fileSystem;
        this.with(path);
        this.with(dataLayout);
    }

    public GBPTreeBuilder(PageCache pageCache, FileSystemAbstraction fileSystem, Path path, Layout<KEY, VALUE> dataLayout, KeyLayout<ROOT_KEY> rootLayout) {
        this.pageCache = pageCache;
        this.fileSystem = fileSystem;
        this.with(path);
        this.with(dataLayout);
        this.withRootLayout(rootLayout);
        this.treeNodeLayoutFactory = TreeNodeLayoutFactory.getInstance();
    }

    public GBPTreeBuilder<ROOT_KEY, KEY, VALUE> with(Layout<KEY, VALUE> layout) {
        this.dataLayout = layout;
        return this;
    }

    public GBPTreeBuilder<ROOT_KEY, KEY, VALUE> withRootLayout(KeyLayout<ROOT_KEY> layout) {
        this.rootLayout = layout;
        return this;
    }

    public GBPTreeBuilder<ROOT_KEY, KEY, VALUE> with(Path file) {
        this.path = file;
        return this;
    }

    public GBPTreeBuilder<ROOT_KEY, KEY, VALUE> with(MultiRootGBPTree.Monitor monitor) {
        this.monitor = monitor;
        return this;
    }

    public GBPTreeBuilder<ROOT_KEY, KEY, VALUE> with(Header.Reader headerReader) {
        this.headerReader = headerReader;
        return this;
    }

    public GBPTreeBuilder<ROOT_KEY, KEY, VALUE> with(Consumer<PageCursor> headerWriter) {
        this.headerWriter = headerWriter;
        return this;
    }

    public GBPTreeBuilder<ROOT_KEY, KEY, VALUE> with(RecoveryCleanupWorkCollector recoveryCleanupWorkCollector) {
        this.recoveryCleanupWorkCollector = recoveryCleanupWorkCollector;
        return this;
    }

    public GBPTreeBuilder<ROOT_KEY, KEY, VALUE> with(DatabaseReadOnlyChecker readOnlyChecker) {
        this.readOnlyChecker = readOnlyChecker;
        return this;
    }

    public GBPTreeBuilder<ROOT_KEY, KEY, VALUE> with(PageCacheTracer pageCacheTracer) {
        this.pageCacheTracer = pageCacheTracer;
        return this;
    }

    public GBPTreeBuilder<ROOT_KEY, KEY, VALUE> with(ImmutableSet<OpenOption> openOptions) {
        this.openOptions = openOptions;
        return this;
    }

    public GBPTreeBuilder<ROOT_KEY, KEY, VALUE> with(TreeNodeLayoutFactory treeNodeLayoutFactory) {
        this.treeNodeLayoutFactory = treeNodeLayoutFactory;
        return this;
    }

    public GBPTree<KEY, VALUE> build() {
        CursorContextFactory cursorContextFactory = new CursorContextFactory(this.pageCacheTracer, EmptyVersionContextSupplier.EMPTY);
        return new GBPTree(this.pageCache, this.fileSystem, this.path, this.dataLayout, this.monitor, this.headerReader, this.headerWriter, this.recoveryCleanupWorkCollector, this.readOnlyChecker, this.openOptions, "neo4j", "test tree", cursorContextFactory, this.pageCacheTracer, this.treeNodeLayoutFactory);
    }

    public MultiRootGBPTree<ROOT_KEY, KEY, VALUE> buildMultiRoot() {
        CursorContextFactory cursorContextFactory = new CursorContextFactory(this.pageCacheTracer, EmptyVersionContextSupplier.EMPTY);
        return new MultiRootGBPTree(this.pageCache, this.fileSystem, this.path, this.dataLayout, this.monitor, this.headerReader, this.headerWriter, this.recoveryCleanupWorkCollector, this.readOnlyChecker, this.openOptions, "neo4j", "test tree", cursorContextFactory, RootLayerConfiguration.multipleRoots(this.rootLayout, (int)((int)ByteUnit.kibiBytes((long)10L))), this.pageCacheTracer, this.treeNodeLayoutFactory);
    }
}

