/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.neo4j.index.internal.gbptree.RawBytes;
import org.neo4j.index.internal.gbptree.TestLayout;
import org.neo4j.io.memory.ByteBuffers;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;

public class SimpleByteArrayLayout
extends TestLayout<RawBytes, RawBytes> {
    private static final int DEFAULT_LARGE_ENTRY_SIZE = 8;
    private static final long NO_LARGE_ENTRIES_MODULO = 0L;
    private final boolean useFirstLongAsSeed;
    private final int largeEntriesSize;
    private final long largeEntryModulo;

    public SimpleByteArrayLayout() {
        this(true, 8, 0L);
    }

    public SimpleByteArrayLayout(boolean useFirstLongAsSeed) {
        this(useFirstLongAsSeed, 8, 0L);
    }

    public SimpleByteArrayLayout(int largeEntriesSize, long largeEntryModulo) {
        this(true, largeEntriesSize, largeEntryModulo);
    }

    private SimpleByteArrayLayout(boolean useFirstLongAsSeed, int largeEntriesSize, long largeEntryModulo) {
        super(false, 666L, 0, 0);
        this.useFirstLongAsSeed = useFirstLongAsSeed;
        this.largeEntriesSize = largeEntriesSize;
        this.largeEntryModulo = largeEntryModulo;
    }

    public RawBytes newKey() {
        return new RawBytes(null);
    }

    public RawBytes copyKey(RawBytes rawBytes, RawBytes into) {
        if (rawBytes.bytes == null) {
            throw new IllegalStateException("source key was not initialized before copy");
        }
        return SimpleByteArrayLayout.copyKey(rawBytes, into, rawBytes.bytes.length);
    }

    private static RawBytes copyKey(RawBytes rawBytes, RawBytes into, int length) {
        into.bytes = Arrays.copyOf(rawBytes.bytes, length);
        return into;
    }

    public RawBytes newValue() {
        return new RawBytes();
    }

    public int keySize(RawBytes rawBytes) {
        if (rawBytes == null) {
            return -1;
        }
        if (rawBytes.bytes == null) {
            throw new IllegalStateException("key was not initialized");
        }
        return rawBytes.bytes.length;
    }

    public int valueSize(RawBytes rawBytes) {
        if (rawBytes == null) {
            return -1;
        }
        return rawBytes.bytes.length;
    }

    public void writeKey(PageCursor cursor, RawBytes rawBytes) {
        cursor.putBytes(rawBytes.bytes);
    }

    public void writeValue(PageCursor cursor, RawBytes rawBytes) {
        cursor.putBytes(rawBytes.bytes);
    }

    public void readKey(PageCursor cursor, RawBytes into, int keySize) {
        into.bytes = new byte[keySize];
        cursor.getBytes(into.bytes);
    }

    public void readValue(PageCursor cursor, RawBytes into, int valueSize) {
        into.bytes = new byte[valueSize];
        cursor.getBytes(into.bytes);
    }

    public void minimalSplitter(RawBytes left, RawBytes right, RawBytes into) {
        long leftSeed = this.keySeed(left);
        long rightSeed = this.keySeed(right);
        if (this.useFirstLongAsSeed && leftSeed != rightSeed) {
            SimpleByteArrayLayout.copyKey(right, into, 8);
        } else {
            int firstIndexToDiffer;
            int maxLength = Math.min(left.bytes.length, right.bytes.length);
            for (firstIndexToDiffer = 0; firstIndexToDiffer < maxLength && left.bytes[firstIndexToDiffer] == right.bytes[firstIndexToDiffer]; ++firstIndexToDiffer) {
            }
            int targetLength = firstIndexToDiffer + 1;
            SimpleByteArrayLayout.copyKey(right, into, targetLength);
        }
    }

    public int compare(RawBytes o1, RawBytes o2) {
        if (o1.bytes == null) {
            return -1;
        }
        if (o2.bytes == null) {
            return 1;
        }
        if (this.useFirstLongAsSeed) {
            int compare = Long.compare(this.keySeed(o1), this.keySeed(o2));
            return compare != 0 ? compare : SimpleByteArrayLayout.byteArrayCompare(o1.bytes, o2.bytes, 8);
        }
        return SimpleByteArrayLayout.byteArrayCompare(o1.bytes, o2.bytes, 0);
    }

    @Override
    protected int compareValue(RawBytes v1, RawBytes v2) {
        return this.compare(v1, v2);
    }

    private static int byteArrayCompare(byte[] a, byte[] b, int fromPos) {
        assert (a != null && b != null) : "Null arrays not supported.";
        if (a == b) {
            return 0;
        }
        int length = Math.min(a.length, b.length);
        for (int i = fromPos; i < length; ++i) {
            int compare = Byte.compare(a[i], b[i]);
            if (compare == 0) continue;
            return compare;
        }
        return Integer.compare(a.length, b.length);
    }

    @Override
    public RawBytes key(long seed) {
        RawBytes key = this.newKey();
        key.bytes = this.fromSeed(seed);
        return key;
    }

    @Override
    public RawBytes value(long seed) {
        RawBytes value = this.newValue();
        value.bytes = this.fromSeed(seed);
        return value;
    }

    @Override
    public long keySeed(RawBytes rawBytes) {
        return SimpleByteArrayLayout.toSeed(rawBytes);
    }

    @Override
    public long valueSeed(RawBytes rawBytes) {
        return SimpleByteArrayLayout.toSeed(rawBytes);
    }

    public void initializeAsLowest(RawBytes rawBytes) {
        rawBytes.bytes = new byte[8];
        Arrays.fill(rawBytes.bytes, (byte)-128);
    }

    public void initializeAsHighest(RawBytes rawBytes) {
        rawBytes.bytes = new byte[8];
        Arrays.fill(rawBytes.bytes, (byte)127);
    }

    private static long toSeed(RawBytes rawBytes) {
        ByteBuffer buffer = ByteBuffers.allocate((int)8, (ByteOrder)ByteOrder.BIG_ENDIAN, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        byte[] bytes = rawBytes.bytes;
        if (bytes.length >= 8) {
            buffer.put(bytes, 0, 8);
            buffer.flip();
            return buffer.getLong();
        }
        return 0L;
    }

    private byte[] fromSeed(long seed) {
        int tail = (int)Math.abs(seed % 8L);
        if (this.largeEntryModulo != 0L && seed % this.largeEntryModulo == 0L) {
            tail = this.largeEntriesSize - 8;
        }
        ByteBuffer buffer = ByteBuffers.allocate((int)(8 + tail), (ByteOrder)ByteOrder.BIG_ENDIAN, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        buffer.putLong(seed);
        buffer.put(new byte[tail]);
        return buffer.array();
    }

    public long highestUsableSeed() {
        RawBytes key = this.newKey();
        this.initializeAsHighest(key);
        return this.keySeed(key) - 1L;
    }
}

