/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.IOException;
import org.neo4j.index.internal.gbptree.CursorCreator;
import org.neo4j.index.internal.gbptree.DynamicSizeUtil;
import org.neo4j.index.internal.gbptree.FreeListIdProvider;
import org.neo4j.index.internal.gbptree.GBPTreePointerType;
import org.neo4j.index.internal.gbptree.GBPTreeUnsafe;
import org.neo4j.index.internal.gbptree.GenerationSafePointer;
import org.neo4j.index.internal.gbptree.GenerationSafePointerPair;
import org.neo4j.index.internal.gbptree.InternalNodeBehaviour;
import org.neo4j.index.internal.gbptree.InternalNodeDynamicSize;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.LeafNodeBehaviour;
import org.neo4j.index.internal.gbptree.PointerWithGeneration;
import org.neo4j.index.internal.gbptree.TreeNodeUtil;
import org.neo4j.index.internal.gbptree.TreeState;
import org.neo4j.index.internal.gbptree.ValueHolder;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.context.CursorContext;

public final class GBPTreeCorruption {
    private GBPTreeCorruption() {
    }

    public static <KEY, VALUE> PageCorruption<KEY, VALUE> crashed(GBPTreePointerType gbpTreePointerType) {
        return (pageCursor, layout, leafNode, internalNode, treeState) -> {
            int offset = gbpTreePointerType.offset(internalNode);
            long stableGeneration = treeState.stableGeneration();
            long unstableGeneration = treeState.unstableGeneration();
            long crashGeneration = GBPTreeCorruption.crashGeneration(treeState);
            pageCursor.setOffset(offset);
            long pointer = GenerationSafePointerPair.pointer((long)GenerationSafePointerPair.read((PageCursor)pageCursor, (long)stableGeneration, (long)unstableGeneration).pointer());
            GBPTreeCorruption.overwriteGSPP(pageCursor, offset, crashGeneration, pointer);
        };
    }

    public static <KEY, VALUE> PageCorruption<KEY, VALUE> broken(GBPTreePointerType gbpTreePointerType) {
        return (pageCursor, layout, leafNode, internalNode, treeState) -> {
            int offset = gbpTreePointerType.offset(internalNode);
            pageCursor.setOffset(offset);
            pageCursor.putInt(Integer.MAX_VALUE);
        };
    }

    public static <KEY, VALUE> PageCorruption<KEY, VALUE> setPointer(GBPTreePointerType pointerType, long pointer) {
        return (cursor, layout, leafNode, internalNode, treeState) -> GBPTreeCorruption.overwriteGSPP(cursor, pointerType.offset(internalNode), treeState.stableGeneration(), pointer);
    }

    public static <KEY, VALUE> PageCorruption<KEY, VALUE> notATreeNode() {
        return (cursor, layout, leafNode, internalNode, treeState) -> cursor.putByte(0, (byte)127);
    }

    public static <KEY, VALUE> PageCorruption<KEY, VALUE> notAnOffloadNode() {
        return (cursor, layout, leafNode, internalNode, treeState) -> cursor.putByte(0, (byte)127);
    }

    public static <KEY, VALUE> PageCorruption<KEY, VALUE> unknownTreeNodeType() {
        return (cursor, layout, leafNode, internalNode, treeState) -> cursor.putByte(1, (byte)127);
    }

    public static <KEY, VALUE> PageCorruption<KEY, VALUE> rightSiblingPointToNonExisting() {
        return (cursor, layout, leafNode, internalNode, treeState) -> GBPTreeCorruption.overwriteGSPP(cursor, GBPTreePointerType.rightSibling().offset(internalNode), treeState.stableGeneration(), 0xFFFFFFFFFFFFL);
    }

    public static <KEY, VALUE> PageCorruption<KEY, VALUE> leftSiblingPointToNonExisting() {
        return (cursor, layout, leafNode, internalNode, treeState) -> GBPTreeCorruption.overwriteGSPP(cursor, GBPTreePointerType.leftSibling().offset(internalNode), treeState.stableGeneration(), 0xFFFFFFFFFFFFL);
    }

    public static <KEY, VALUE> PageCorruption<KEY, VALUE> rightSiblingPointerHasTooLowGeneration() {
        return (cursor, layout, leafNode, internalNode, treeState) -> {
            long rightSibling = GenerationSafePointerPair.pointer((long)TreeNodeUtil.rightSibling((PageCursor)cursor, (long)treeState.stableGeneration(), (long)treeState.unstableGeneration()).pointer());
            GBPTreeCorruption.overwriteGSPP(cursor, 10, 1L, rightSibling);
        };
    }

    public static <KEY, VALUE> PageCorruption<KEY, VALUE> leftSiblingPointerHasTooLowGeneration() {
        return (cursor, layout, leafNode, internalNode, treeState) -> {
            long leftSibling = GenerationSafePointerPair.pointer((long)TreeNodeUtil.leftSibling((PageCursor)cursor, (long)treeState.stableGeneration(), (long)treeState.unstableGeneration()).pointer());
            GBPTreeCorruption.overwriteGSPP(cursor, 34, 1L, leftSibling);
        };
    }

    public static <KEY, VALUE> PageCorruption<KEY, VALUE> childPointerHasTooLowGeneration(int childPos) {
        return (cursor, layout, leafNode, internalNode, treeState) -> {
            long stableGeneration = treeState.stableGeneration();
            long unstableGeneration = treeState.unstableGeneration();
            long child = GenerationSafePointerPair.pointer((long)internalNode.childAt(cursor, childPos, stableGeneration, unstableGeneration));
            GBPTreeCorruption.overwriteGSPP(cursor, internalNode.childOffset(childPos), 1L, child);
        };
    }

    public static <KEY, VALUE> PageCorruption<KEY, VALUE> setChild(int childPos, long childPointer) {
        return (cursor, layout, leafNode, internalNode, treeState) -> {
            long stableGeneration = treeState.stableGeneration();
            long unstableGeneration = treeState.unstableGeneration();
            PointerWithGeneration pointer = internalNode.childWithGenerationAt(cursor, childPos, stableGeneration, unstableGeneration);
            GBPTreeCorruption.overwriteGSPP(cursor, GBPTreePointerType.child((int)childPos).offset(internalNode), pointer.generation(), childPointer);
        };
    }

    public static <KEY, VALUE> PageCorruption<KEY, VALUE> hasSuccessor() {
        return (cursor, layout, leafNode, internalNode, treeState) -> GBPTreeCorruption.overwriteGSPP(cursor, 58, treeState.unstableGeneration(), 0xFFFFFFFFFFFFL);
    }

    public static <KEY, VALUE> PageCorruption<KEY, VALUE> swapKeyOrderLeaf(int firstKeyPos, int secondKeyPos, int keyCount) {
        return (cursor, layout, leafNode, internalNode, treeState) -> {
            int lowerKeyPos = Math.min(firstKeyPos, secondKeyPos);
            int higherKeyPos = firstKeyPos == lowerKeyPos ? secondKeyPos : firstKeyPos;
            Object key = layout.newKey();
            Object value = layout.newValue();
            leafNode.keyAt(cursor, key, higherKeyPos, CursorContext.NULL_CONTEXT);
            leafNode.valueAt(cursor, new ValueHolder(value), higherKeyPos, CursorContext.NULL_CONTEXT);
            long stableGeneration1 = treeState.stableGeneration();
            long unstableGeneration1 = treeState.unstableGeneration();
            int newCount = leafNode.removeKeyValueAt(cursor, higherKeyPos, keyCount, stableGeneration1, unstableGeneration1, CursorContext.NULL_CONTEXT);
            TreeNodeUtil.setKeyCount((PageCursor)cursor, (int)newCount);
            leafNode.defragment(cursor, newCount, CursorContext.NULL_CONTEXT);
            long stableGeneration = treeState.stableGeneration();
            long unstableGeneration = treeState.unstableGeneration();
            leafNode.insertKeyValueAt(cursor, key, value, lowerKeyPos, newCount, stableGeneration, unstableGeneration, CursorContext.NULL_CONTEXT);
            TreeNodeUtil.setKeyCount((PageCursor)cursor, (int)keyCount);
        };
    }

    public static <KEY, VALUE> PageCorruption<KEY, VALUE> swapKeyOrderInternal(int firstKeyPos, int secondKeyPos, int keyCount) {
        return (cursor, layout, leafNode, internalNode, treeState) -> {
            int lowerKeyPos = Math.min(firstKeyPos, secondKeyPos);
            int higherKeyPos = firstKeyPos == lowerKeyPos ? secondKeyPos : firstKeyPos;
            Object key = layout.newKey();
            internalNode.keyAt(cursor, key, higherKeyPos, CursorContext.NULL_CONTEXT);
            long stableGeneration2 = treeState.stableGeneration();
            long unstableGeneration2 = treeState.unstableGeneration();
            PointerWithGeneration rightChild = internalNode.childWithGenerationAt(cursor, higherKeyPos + 1, stableGeneration2, unstableGeneration2);
            long stableGeneration1 = treeState.stableGeneration();
            long unstableGeneration1 = treeState.unstableGeneration();
            internalNode.removeKeyAndRightChildAt(cursor, higherKeyPos, keyCount, stableGeneration1, unstableGeneration1, CursorContext.NULL_CONTEXT);
            TreeNodeUtil.setKeyCount((PageCursor)cursor, (int)(keyCount - 1));
            internalNode.defragment(cursor, keyCount - 1);
            long stableGeneration = treeState.stableGeneration();
            long unstableGeneration = treeState.unstableGeneration();
            internalNode.insertKeyAndRightChildAt(cursor, key, rightChild.pointer(), lowerKeyPos, keyCount - 1, stableGeneration, unstableGeneration, CursorContext.NULL_CONTEXT);
            TreeNodeUtil.setKeyCount((PageCursor)cursor, (int)keyCount);
            int childOffset = internalNode.childOffset(lowerKeyPos + 1);
            GBPTreeCorruption.overwriteGSPP(cursor, childOffset, rightChild.generation(), rightChild.pointer());
        };
    }

    public static <KEY, VALUE> PageCorruption<KEY, VALUE> swapChildOrder(int firstChildPos, int secondChildPos) {
        return (cursor, layout, leafNode, internalNode, treeState) -> {
            long stableGeneration1 = treeState.stableGeneration();
            long unstableGeneration1 = treeState.unstableGeneration();
            PointerWithGeneration firstChild = internalNode.childWithGenerationAt(cursor, firstChildPos, stableGeneration1, unstableGeneration1);
            long stableGeneration = treeState.stableGeneration();
            long unstableGeneration = treeState.unstableGeneration();
            PointerWithGeneration secondChild = internalNode.childWithGenerationAt(cursor, secondChildPos, stableGeneration, unstableGeneration);
            GBPTreeCorruption.overwriteGSPP(cursor, GBPTreePointerType.child((int)firstChildPos).offset(internalNode), secondChild.generation(), secondChild.pointer());
            GBPTreeCorruption.overwriteGSPP(cursor, GBPTreePointerType.child((int)secondChildPos).offset(internalNode), firstChild.generation(), firstChild.pointer());
        };
    }

    public static <KEY, VALUE> PageCorruption<KEY, VALUE> overwriteKeyAtPosLeaf(KEY key, int keyPos, int keyCount) {
        return (cursor, layout, leafNode, internalNode, treeState) -> {
            Object value = layout.newValue();
            leafNode.valueAt(cursor, new ValueHolder(value), keyPos, CursorContext.NULL_CONTEXT);
            long stableGeneration1 = treeState.stableGeneration();
            long unstableGeneration1 = treeState.unstableGeneration();
            leafNode.removeKeyValueAt(cursor, keyPos, keyCount, stableGeneration1, unstableGeneration1, CursorContext.NULL_CONTEXT);
            TreeNodeUtil.setKeyCount((PageCursor)cursor, (int)(keyCount - 1));
            leafNode.defragment(cursor, keyCount - 1, CursorContext.NULL_CONTEXT);
            long stableGeneration = treeState.stableGeneration();
            long unstableGeneration = treeState.unstableGeneration();
            leafNode.insertKeyValueAt(cursor, key, value, keyPos, keyCount - 1, stableGeneration, unstableGeneration, CursorContext.NULL_CONTEXT);
            TreeNodeUtil.setKeyCount((PageCursor)cursor, (int)keyCount);
        };
    }

    public static <KEY, VALUE> PageCorruption<KEY, VALUE> overwriteKeyAtPosInternal(KEY key, int keyPos, int keyCount) {
        return (cursor, layout, leafNode, internalNode, treeState) -> {
            long stableGeneration2 = treeState.stableGeneration();
            long unstableGeneration2 = treeState.unstableGeneration();
            long rightChild = internalNode.childAt(cursor, keyPos + 1, stableGeneration2, unstableGeneration2);
            long stableGeneration1 = treeState.stableGeneration();
            long unstableGeneration1 = treeState.unstableGeneration();
            internalNode.removeKeyAndRightChildAt(cursor, keyPos, keyCount, stableGeneration1, unstableGeneration1, CursorContext.NULL_CONTEXT);
            TreeNodeUtil.setKeyCount((PageCursor)cursor, (int)(keyCount - 1));
            internalNode.defragment(cursor, keyCount - 1);
            long stableGeneration = treeState.stableGeneration();
            long unstableGeneration = treeState.unstableGeneration();
            internalNode.insertKeyAndRightChildAt(cursor, key, rightChild, keyPos, keyCount - 1, stableGeneration, unstableGeneration, CursorContext.NULL_CONTEXT);
            TreeNodeUtil.setKeyCount((PageCursor)cursor, (int)keyCount);
        };
    }

    public static <KEY, VALUE> PageCorruption<KEY, VALUE> maximizeAllocOffsetInDynamicNode() {
        return (cursor, layout, leafNode, internalNode, treeState) -> {
            GBPTreeCorruption.assertDynamicNode(internalNode);
            DynamicSizeUtil.setAllocOffset((PageCursor)cursor, (int)cursor.getPagedFile().payloadSize());
        };
    }

    public static <KEY, VALUE> PageCorruption<KEY, VALUE> minimizeAllocOffsetInDynamicNode() {
        return (cursor, layout, leafNode, internalNode, treeState) -> {
            GBPTreeCorruption.assertDynamicNode(internalNode);
            DynamicSizeUtil.setAllocOffset((PageCursor)cursor, (int)86);
        };
    }

    public static <KEY, VALUE> PageCorruption<KEY, VALUE> decrementAllocOffsetInDynamicNode() {
        return (cursor, layout, leafNode, internalNode, treeState) -> {
            GBPTreeCorruption.assertDynamicNode(internalNode);
            int allocOffset = DynamicSizeUtil.getAllocOffset((PageCursor)cursor);
            DynamicSizeUtil.setAllocOffset((PageCursor)cursor, (int)(allocOffset - 1));
        };
    }

    public static <KEY, VALUE> PageCorruption<KEY, VALUE> incrementDeadSpaceInDynamicNode() {
        return (cursor, layout, leafNode, internalNode, treeState) -> {
            GBPTreeCorruption.assertDynamicNode(internalNode);
            int deadSpace = DynamicSizeUtil.getDeadSpace((PageCursor)cursor);
            DynamicSizeUtil.setDeadSpace((PageCursor)cursor, (int)(deadSpace + 1));
        };
    }

    public static <KEY, VALUE> IndexCorruption<KEY, VALUE> decrementFreelistWritePos() {
        return (pagedFile, layout, leafNode, internalNode, treeState) -> {
            try (PageCursor cursor = pagedFile.io(0L, 2, CursorContext.NULL_CONTEXT);){
                TreeNodeUtil.goTo((PageCursor)cursor, (String)"", (long)treeState.pageId());
                int decrementedWritePos = treeState.freeListWritePos() - 1;
                TreeState.write((PageCursor)cursor, (long)treeState.stableGeneration(), (long)treeState.unstableGeneration(), (long)treeState.rootId(), (long)treeState.rootGeneration(), (long)treeState.lastId(), (long)treeState.freeListWritePageId(), (long)treeState.freeListReadPageId(), (int)decrementedWritePos, (int)treeState.freeListReadPos(), (boolean)treeState.isClean());
            }
        };
    }

    public static <KEY, VALUE> IndexCorruption<KEY, VALUE> addFreelistEntry(long releasedId) {
        return (pagedFile, layout, leafNode, internalNode, treeState) -> {
            FreeListIdProvider freelist = GBPTreeCorruption.getFreelist(pagedFile, treeState);
            CursorCreator cursorCreator = CursorCreator.bind((PagedFile)pagedFile, (int)2, (CursorContext)CursorContext.NULL_CONTEXT);
            freelist.releaseId(treeState.stableGeneration(), treeState.unstableGeneration(), releasedId, cursorCreator);
            freelist.flush(treeState.stableGeneration(), treeState.unstableGeneration(), cursorCreator);
            try (PageCursor cursor = pagedFile.io(0L, 2, CursorContext.NULL_CONTEXT);){
                TreeNodeUtil.goTo((PageCursor)cursor, (String)"", (long)treeState.pageId());
                FreeListIdProvider.FreelistMetaData freelistMetaData = freelist.metaData();
                TreeState.write((PageCursor)cursor, (long)treeState.stableGeneration(), (long)treeState.unstableGeneration(), (long)treeState.rootId(), (long)treeState.rootGeneration(), (long)freelistMetaData.lastId(), (long)freelistMetaData.writePageId(), (long)freelistMetaData.readPageId(), (int)freelistMetaData.writePos(), (int)freelistMetaData.readPos(), (boolean)treeState.isClean());
            }
        };
    }

    public static <KEY, VALUE> IndexCorruption<KEY, VALUE> setTreeState(TreeState target) {
        return (pagedFile, layout, leafNode, internalNode, treeState) -> {
            try (PageCursor cursor = pagedFile.io(0L, 2, CursorContext.NULL_CONTEXT);){
                TreeNodeUtil.goTo((PageCursor)cursor, (String)"", (long)treeState.pageId());
                TreeState.write((PageCursor)cursor, (long)target.stableGeneration(), (long)target.unstableGeneration(), (long)target.rootId(), (long)target.rootGeneration(), (long)target.lastId(), (long)target.freeListWritePageId(), (long)target.freeListReadPageId(), (int)target.freeListWritePos(), (int)target.freeListReadPos(), (boolean)target.isClean());
            }
        };
    }

    public static <VALUE, KEY> IndexCorruption<KEY, VALUE> copyChildPointerFromOther(long targetInternalNode, long otherInternalNode, int targetChildPos, int otherChildPos) {
        return (pagedFile, layout, leafNode, internalNode, treeState) -> {
            try (PageCursor cursor = pagedFile.io(0L, 2, CursorContext.NULL_CONTEXT);){
                TreeNodeUtil.goTo((PageCursor)cursor, (String)"", (long)otherInternalNode);
                long stableGeneration = treeState.stableGeneration();
                long unstableGeneration = treeState.unstableGeneration();
                PointerWithGeneration child = internalNode.childWithGenerationAt(cursor, otherChildPos, stableGeneration, unstableGeneration);
                TreeNodeUtil.goTo((PageCursor)cursor, (String)"", (long)targetInternalNode);
                GBPTreeCorruption.overwriteGSPP(cursor, GBPTreePointerType.child((int)targetChildPos).offset(internalNode), child.generation(), child.pointer());
            }
        };
    }

    public static <KEY, VALUE> PageCorruption<KEY, VALUE> setKeyCount(int keyCount) {
        return (cursor, layout, leafNode, internalNode, treeState) -> cursor.putInt(6, keyCount);
    }

    public static <KEY, VALUE> PageCorruption<KEY, VALUE> setHighestReasonableKeyCount() {
        return (cursor, layout, leafNode, internalNode, treeState) -> {
            int keyCount = 0;
            while (keyCount + 1 >= 0 && keyCount + 1 <= Math.max(internalNode.maxKeyCount(), leafNode.maxKeyCount())) {
                ++keyCount;
            }
            cursor.putInt(6, keyCount);
        };
    }

    public static <KEY, VALUE> IndexCorruption<KEY, VALUE> pageSpecificCorruption(long targetPage, PageCorruption<KEY, VALUE> corruption) {
        return (pagedFile, layout, leafNode, internalNode, treeState) -> {
            try (PageCursor cursor = pagedFile.io(0L, 2, CursorContext.NULL_CONTEXT);){
                TreeNodeUtil.goTo((PageCursor)cursor, (String)"", (long)targetPage);
                corruption.corrupt(cursor, layout, leafNode, internalNode, treeState);
            }
        };
    }

    public static <KEY, VALUE> IndexCorruption<KEY, VALUE> makeDirty() {
        return (pagedFile, layout, leafNode, internalNode, treeState) -> {
            try (PageCursor cursor = pagedFile.io(0L, 2, CursorContext.NULL_CONTEXT);){
                TreeNodeUtil.goTo((PageCursor)cursor, (String)"", (long)treeState.pageId());
                TreeState.write((PageCursor)cursor, (long)(treeState.stableGeneration() + 1L), (long)(treeState.unstableGeneration() + 1L), (long)treeState.rootId(), (long)treeState.rootGeneration(), (long)treeState.lastId(), (long)treeState.freeListWritePageId(), (long)treeState.freeListReadPageId(), (int)treeState.freeListWritePos(), (int)treeState.freeListReadPos(), (boolean)false);
            }
        };
    }

    private static FreeListIdProvider getFreelist(PagedFile pagedFile, TreeState treeState) {
        FreeListIdProvider freelist = new FreeListIdProvider(pagedFile.payloadSize());
        freelist.initialize(treeState.lastId(), treeState.freeListWritePageId(), treeState.freeListReadPageId(), treeState.freeListWritePos(), 0);
        return freelist;
    }

    private static void assertDynamicNode(InternalNodeBehaviour<?> node) {
        if (!(node instanceof InternalNodeDynamicSize)) {
            throw new RuntimeException("Can not use this corruption if node is not of dynamic type");
        }
    }

    private static void overwriteGSPP(PageCursor cursor, int gsppOffset, long generation, long pointer) {
        cursor.setOffset(gsppOffset);
        GenerationSafePointer.write((PageCursor)cursor, (long)generation, (long)pointer);
        GenerationSafePointer.clean((PageCursor)cursor);
    }

    private static long crashGeneration(TreeState treeState) {
        if (treeState.unstableGeneration() - treeState.stableGeneration() < 2L) {
            throw new IllegalStateException("Need stable and unstable generation to have a crash gap but was stableGeneration=" + treeState.stableGeneration() + " and unstableGeneration=" + treeState.unstableGeneration());
        }
        return treeState.unstableGeneration() - 1L;
    }

    public static interface PageCorruption<KEY, VALUE> {
        public void corrupt(PageCursor var1, Layout<KEY, VALUE> var2, LeafNodeBehaviour<KEY, VALUE> var3, InternalNodeBehaviour<KEY> var4, TreeState var5) throws IOException;
    }

    public static interface IndexCorruption<KEY, VALUE>
    extends GBPTreeUnsafe<KEY, VALUE> {
    }
}

