/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.value;

import org.neo4j.bolt.connection.values.Type;
import org.neo4j.bolt.connection.values.Vector;
import org.neo4j.driver.internal.AbstractArrayVector;
import org.neo4j.driver.internal.types.InternalTypeSystem;
import org.neo4j.driver.internal.value.ObjectValueAdapter;
import org.neo4j.driver.types.Float32Vector;
import org.neo4j.driver.types.Float64Vector;
import org.neo4j.driver.types.Int16Vector;
import org.neo4j.driver.types.Int32Vector;
import org.neo4j.driver.types.Int64Vector;
import org.neo4j.driver.types.Int8Vector;

public class VectorValue
extends ObjectValueAdapter<org.neo4j.driver.types.Vector> {
    public VectorValue(org.neo4j.driver.types.Vector vector) {
        super(vector);
    }

    @Override
    public org.neo4j.driver.types.Type type() {
        return InternalTypeSystem.TYPE_SYSTEM.VECTOR();
    }

    public Type boltValueType() {
        return Type.VECTOR;
    }

    @Override
    public org.neo4j.driver.types.Vector asVector() {
        return (org.neo4j.driver.types.Vector)this.asObject();
    }

    @Override
    public <T> T as(Class<T> targetClass) {
        if (targetClass.isAssignableFrom(Int8Vector.class) || targetClass.isAssignableFrom(Int16Vector.class) || targetClass.isAssignableFrom(Int32Vector.class) || targetClass.isAssignableFrom(Int64Vector.class) || targetClass.isAssignableFrom(Float32Vector.class) || targetClass.isAssignableFrom(Float64Vector.class)) {
            return targetClass.cast(this.asObject());
        }
        if (targetClass.isArray()) {
            AbstractArrayVector arrayVector = (AbstractArrayVector)this.asObject();
            if (targetClass.getComponentType().equals(arrayVector.elementType())) {
                return targetClass.cast(arrayVector.toArray());
            }
            throw new AssertionError((Object)("Unsupported type: " + String.valueOf(targetClass)));
        }
        return this.asMapped(targetClass);
    }

    @Override
    public Vector asBoltVector() {
        return (AbstractArrayVector)this.asObject();
    }
}

