/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.util;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.function.BiConsumer;
import org.neo4j.driver.internal.util.ErrorUtil;

public final class Futures {
    private static final CompletableFuture<?> COMPLETED_WITH_NULL = CompletableFuture.completedFuture(null);

    private Futures() {
    }

    public static <T> CompletableFuture<T> completedWithNull() {
        return COMPLETED_WITH_NULL;
    }

    public static <V> V blockingGet(CompletionStage<V> stage) {
        return Futures.blockingGet(stage, Futures::noOpInterruptHandler);
    }

    public static <V> V blockingGet(CompletionStage<V> stage, Runnable interruptHandler) {
        Futures.assertNotInEventLoopThread();
        CompletableFuture<V> future = stage.toCompletableFuture();
        boolean interrupted = false;
        while (true) {
            try {
                Object v = future.get();
                return v;
            }
            catch (InterruptedException e) {
                interrupted = true;
                Futures.safeRun(interruptHandler);
                continue;
            }
            catch (ExecutionException e) {
                ErrorUtil.rethrowAsyncException(e);
                continue;
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static <T> T getNow(CompletionStage<T> stage) {
        return stage.toCompletableFuture().getNow(null);
    }

    public static Throwable completionExceptionCause(Throwable error) {
        if (error instanceof CompletionException) {
            return error.getCause();
        }
        return error;
    }

    public static CompletionException asCompletionException(Throwable error) {
        if (error instanceof CompletionException) {
            return (CompletionException)error;
        }
        return new CompletionException(error);
    }

    public static CompletionException combineErrors(Throwable error1, Throwable error2) {
        if (error1 != null && error2 != null) {
            Throwable cause1 = Futures.completionExceptionCause(error1);
            Throwable cause2 = Futures.completionExceptionCause(error2);
            ErrorUtil.addSuppressed(cause1, cause2);
            return Futures.asCompletionException(cause1);
        }
        if (error1 != null) {
            return Futures.asCompletionException(error1);
        }
        if (error2 != null) {
            return Futures.asCompletionException(error2);
        }
        return null;
    }

    public static <T> BiConsumer<T, Throwable> futureCompletingConsumer(CompletableFuture<T> future) {
        return (value, throwable) -> {
            if (throwable != null) {
                future.completeExceptionally((Throwable)throwable);
            } else {
                future.complete(value);
            }
        };
    }

    public static void assertNotInEventLoopThread() throws IllegalStateException {
        if (Futures.isEventLoopThread(Thread.currentThread())) {
            throw new IllegalStateException("Blocking operation can't be executed in IO thread because it might result in a deadlock. Please do not use blocking API when chaining futures returned by async API methods.");
        }
    }

    public static boolean isEventLoopThread(Thread thread) {
        return thread.getClass().getName().equals("org.neo4j.bolt.connection.netty.EventLoopThread");
    }

    private static void safeRun(Runnable runnable) {
        try {
            runnable.run();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void noOpInterruptHandler() {
    }
}

