/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.security;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import org.neo4j.driver.ClientCertificateManager;
import org.neo4j.driver.Logger;
import org.neo4j.driver.Logging;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.internal.GqlStatusError;
import org.neo4j.driver.internal.InternalClientCertificate;
import org.neo4j.driver.internal.pki.PemParser;
import org.neo4j.driver.internal.security.SecurityPlan;
import org.neo4j.driver.internal.util.Futures;

class SSLContextManager {
    private final ClientCertificateManager clientCertificateManager;
    private final SecurityPlan.SSLContextSupplier sslContextSupplier;
    private final Logger logger;
    private CompletableFuture<SSLContext> sslContextFuture;
    private SSLContext sslContext;
    private Throwable throwable;

    public SSLContextManager(ClientCertificateManager clientCertificateManager, SecurityPlan.SSLContextSupplier sslContextSupplier, Logging logging) throws NoSuchAlgorithmException, KeyManagementException {
        this.clientCertificateManager = clientCertificateManager;
        this.sslContextSupplier = sslContextSupplier;
        this.logger = logging.getLog(this.getClass());
        if (clientCertificateManager == null) {
            SSLContext sslContext = sslContextSupplier.get(new KeyManager[0]);
            this.sslContextFuture = CompletableFuture.completedFuture(sslContext);
        }
    }

    public CompletionStage<SSLContext> getSSLContext() {
        return this.clientCertificateManager != null ? this.getSSLContextWithClientCertificate() : this.sslContextFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletionStage<SSLContext> getSSLContextWithClientCertificate() {
        CompletableFuture<SSLContext> sslContextFuture;
        CompletionStage<SSLContext> sslContextStage = null;
        SSLContextManager sSLContextManager = this;
        synchronized (sSLContextManager) {
            if (this.sslContextFuture == null) {
                sslContextFuture = this.sslContextFuture = new CompletableFuture();
                SSLContext sslContext2 = this.sslContext;
                Throwable previousThrowable = this.throwable;
                sslContextStage = this.clientCertificateManager.getClientCertificate().thenApply(clientCertificate -> {
                    if (clientCertificate != null) {
                        InternalClientCertificate certificate = (InternalClientCertificate)clientCertificate;
                        try {
                            KeyManager[] keyManagers = this.createKeyManagers(certificate);
                            return this.sslContextSupplier.get(keyManagers);
                        }
                        catch (Throwable throwable) {
                            String message = "An error occured while loading client certficate.";
                            ClientException exception = new ClientException(GqlStatusError.UNKNOWN.getStatus(), GqlStatusError.UNKNOWN.getStatusDescription(message), "N/A", message, GqlStatusError.DIAGNOSTIC_RECORD, throwable);
                            this.logger.error("An error occured while loading client certficate.", exception);
                            throw new CompletionException(exception);
                        }
                    }
                    if (previousThrowable != null) {
                        throw new CompletionException(previousThrowable);
                    }
                    if (sslContext2 == null) {
                        String message = "The initial client certificate returned by the manager must not be null.";
                        ClientException exception = new ClientException(GqlStatusError.UNKNOWN.getStatus(), GqlStatusError.UNKNOWN.getStatusDescription(message), "N/A", message, GqlStatusError.DIAGNOSTIC_RECORD, null);
                        this.logger.error("The initial client certificate returned by the manager must not be null.", exception);
                        throw new CompletionException(exception);
                    }
                    return sslContext2;
                });
            } else {
                sslContextFuture = this.sslContextFuture;
            }
        }
        if (sslContextStage != null) {
            sslContextStage.whenComplete((sslContext, throwable) -> {
                throwable = Futures.completionExceptionCause(throwable);
                SSLContextManager sSLContextManager = this;
                synchronized (sSLContextManager) {
                    this.sslContextFuture = null;
                    this.sslContext = sslContext;
                    this.throwable = throwable;
                }
                if (throwable != null) {
                    sslContextFuture.completeExceptionally((Throwable)throwable);
                } else {
                    sslContextFuture.complete(this.sslContext);
                }
            });
        }
        return sslContextFuture;
    }

    protected KeyManager[] createKeyManagers(InternalClientCertificate clientCertificate) throws CertificateException, IOException, KeyException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        Collection<? extends Certificate> chain = certificateFactory.generateCertificates(new FileInputStream(clientCertificate.certificate()));
        String password = clientCertificate.password();
        PrivateKey key = new PemParser(new FileInputStream(clientCertificate.privateKey())).getPrivateKey(password);
        KeyStore clientKeyStore = KeyStore.getInstance("JKS");
        char[] pwdChars = password != null ? password.toCharArray() : "password".toCharArray();
        clientKeyStore.load(null, null);
        clientKeyStore.setKeyEntry("neo4j.javadriver.clientcert.", key, pwdChars, chain.toArray(new Certificate[0]));
        KeyManagerFactory keyMgrFactory = KeyManagerFactory.getInstance("SunX509");
        keyMgrFactory.init(clientKeyStore, pwdChars);
        return keyMgrFactory.getKeyManagers();
    }
}

