/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.reactive;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import org.neo4j.driver.Query;
import org.neo4j.driver.internal.async.UnmanagedTransaction;
import org.neo4j.driver.internal.cursor.RxResultCursor;
import org.neo4j.driver.internal.observation.DriverObservationProvider;
import org.neo4j.driver.internal.observation.Observation;
import org.neo4j.driver.internal.observation.util.ObservationUtil;
import org.neo4j.driver.internal.reactive.AbstractReactiveTransaction;
import org.neo4j.driver.internal.reactive.BaseReactiveQueryRunner;
import org.neo4j.driver.internal.reactive.InternalReactiveResult;
import org.neo4j.driver.reactive.ReactiveResult;
import org.neo4j.driver.reactive.ReactiveTransaction;
import reactor.adapter.JdkFlowAdapter;
import reactor.core.publisher.Mono;

public class InternalReactiveTransaction
extends AbstractReactiveTransaction
implements ReactiveTransaction,
BaseReactiveQueryRunner {
    private final DriverObservationProvider observationProvider;

    protected InternalReactiveTransaction(UnmanagedTransaction tx, DriverObservationProvider observationProvider) {
        super(tx);
        this.observationProvider = Objects.requireNonNull(observationProvider);
    }

    @Override
    public Flow.Publisher<ReactiveResult> run(Query query) {
        CompletionStage<Object> cursorStage;
        Observation runObservation = this.observationProvider.transactionRun(ReactiveTransaction.class, query.text(), query.parameters()).start();
        try {
            cursorStage = this.tx.runRx(query, runObservation);
        }
        catch (Throwable t) {
            cursorStage = CompletableFuture.failedFuture(t);
        }
        return JdkFlowAdapter.publisherToFlowPublisher(ObservationUtil.observeStreamsWithoutStart(runObservation, Mono.fromCompletionStage(cursorStage).flatMap(cursor -> {
            Mono publisher;
            Throwable runError = cursor.getRunError();
            if (runError != null) {
                publisher = Mono.error((Throwable)runError);
                this.tx.markTerminated(runError);
            } else {
                publisher = Mono.just((Object)cursor);
            }
            return publisher;
        }).map(result -> new InternalReactiveResult((RxResultCursor)result, this.observationProvider)), false));
    }

    @Override
    public <T> Flow.Publisher<T> commit() {
        Observation commitObservation = this.observationProvider.transactionCommit(ReactiveTransaction.class);
        return JdkFlowAdapter.publisherToFlowPublisher(ObservationUtil.observeStreams(commitObservation, this.doCommit(commitObservation)));
    }

    @Override
    public <T> Flow.Publisher<T> rollback() {
        Observation rollbackObservation = this.observationProvider.transactionRollback(ReactiveTransaction.class);
        return JdkFlowAdapter.publisherToFlowPublisher(ObservationUtil.observeStreams(rollbackObservation, this.doRollback(rollbackObservation)));
    }

    @Override
    public Flow.Publisher<Void> close() {
        Observation closeObservation = this.observationProvider.transactionClose(ReactiveTransaction.class);
        return JdkFlowAdapter.publisherToFlowPublisher(ObservationUtil.observeStreams(closeObservation, this.doClose(closeObservation)));
    }

    @Override
    public Flow.Publisher<Boolean> isOpen() {
        return JdkFlowAdapter.publisherToFlowPublisher(this.doIsOpen());
    }
}

