/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.neo4j.bolt.connection.DatabaseName;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokenManager;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.BookmarkManager;
import org.neo4j.driver.Logging;
import org.neo4j.driver.NotificationConfig;
import org.neo4j.driver.internal.adaptedbolt.DriverBoltConnectionSource;
import org.neo4j.driver.internal.async.NetworkSession;
import org.neo4j.driver.internal.homedb.HomeDatabaseCache;
import org.neo4j.driver.internal.retry.RetryLogic;
import org.neo4j.driver.internal.util.Futures;

public class LeakLoggingNetworkSession
extends NetworkSession {
    private final String stackTrace = LeakLoggingNetworkSession.captureStackTrace();

    public LeakLoggingNetworkSession(DriverBoltConnectionSource connectionProvider, RetryLogic retryLogic, DatabaseName databaseName, AccessMode mode, Set<Bookmark> bookmarks, String impersonatedUser, long fetchSize, Logging logging, BookmarkManager bookmarkManager, NotificationConfig notificationConfig, AuthToken overrideAuthToken, boolean telemetryDisabled, AuthTokenManager authTokenManager, HomeDatabaseCache homeDatabaseCache) {
        super(connectionProvider, retryLogic, databaseName, mode, bookmarks, impersonatedUser, fetchSize, logging, bookmarkManager, notificationConfig, overrideAuthToken, telemetryDisabled, authTokenManager, homeDatabaseCache);
    }

    protected void finalize() throws Throwable {
        this.logLeakIfNeeded();
        super.finalize();
    }

    private void logLeakIfNeeded() {
        Boolean isOpen = Futures.blockingGet(this.currentConnectionIsOpen());
        if (isOpen.booleanValue()) {
            this.log.error("Neo4j Session object leaked, please ensure that your application fully consumes results in Sessions or explicitly calls `close` on Sessions before disposing of the objects.\nSession was create at:\n" + this.stackTrace, null);
        }
    }

    private static String captureStackTrace() {
        StackTraceElement[] elements = Thread.currentThread().getStackTrace();
        return Arrays.stream(elements).map(element -> "\t" + String.valueOf(element) + System.lineSeparator()).collect(Collectors.joining());
    }
}

