/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver;

import java.io.Serializable;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.util.Extract;
import org.neo4j.driver.internal.util.Preconditions;

public final class TransactionConfig
implements Serializable {
    private static final long serialVersionUID = -7954949878657177280L;
    private static final TransactionConfig EMPTY = TransactionConfig.builder().build();
    private final Duration timeout;
    private final Map<String, Object> metadata;
    private volatile transient Map<String, Value> convertedMetadata;

    private TransactionConfig(Builder builder) {
        this.timeout = builder.timeout;
        this.metadata = builder.metadata;
    }

    public static TransactionConfig empty() {
        return EMPTY;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Duration timeout() {
        return this.timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Value> metadata() {
        Map<String, Value> result = this.convertedMetadata;
        if (result == null) {
            TransactionConfig transactionConfig = this;
            synchronized (transactionConfig) {
                result = this.convertedMetadata;
                if (result == null) {
                    result = this.convertedMetadata = Collections.unmodifiableMap(Extract.mapOfValues(this.metadata));
                }
            }
        }
        return result;
    }

    public boolean isEmpty() {
        return this.timeout == null && (this.metadata == null || this.metadata.isEmpty());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionConfig that = (TransactionConfig)o;
        return Objects.equals(this.timeout, that.timeout) && Objects.equals(this.metadata, that.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.timeout, this.metadata);
    }

    public String toString() {
        return "TransactionConfig{timeout=" + String.valueOf(this.timeout) + ", metadata=" + String.valueOf(this.metadata) + "}";
    }

    public static final class Builder {
        private Duration timeout;
        private Map<String, Object> metadata = Collections.emptyMap();

        private Builder() {
        }

        public Builder withTimeout(Duration timeout) {
            Objects.requireNonNull(timeout, "Transaction timeout should not be null");
            Preconditions.checkArgument(!timeout.isNegative(), "Transaction timeout should not be negative");
            this.timeout = timeout;
            return this;
        }

        public Builder withDefaultTimeout() {
            this.timeout = null;
            return this;
        }

        public Builder withMetadata(Map<String, ?> metadata) {
            Objects.requireNonNull(metadata, "Transaction metadata should not be null");
            metadata.values().forEach(Extract::assertParameter);
            this.metadata = new HashMap(metadata);
            return this;
        }

        public TransactionConfig build() {
            return new TransactionConfig(this);
        }
    }
}

