/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.value;

import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import org.neo4j.bolt.connection.values.Type;
import org.neo4j.driver.exceptions.value.Uncoercible;
import org.neo4j.driver.internal.types.InternalTypeSystem;
import org.neo4j.driver.internal.value.ObjectValueAdapter;

public class DateTimeValue
extends ObjectValueAdapter<ZonedDateTime> {
    public DateTimeValue(ZonedDateTime zonedDateTime) {
        super(zonedDateTime);
    }

    @Override
    public OffsetDateTime asOffsetDateTime() {
        return this.asZonedDateTime().toOffsetDateTime();
    }

    @Override
    public ZonedDateTime asZonedDateTime() {
        return (ZonedDateTime)this.asObject();
    }

    @Override
    public org.neo4j.driver.types.Type type() {
        return InternalTypeSystem.TYPE_SYSTEM.DATE_TIME();
    }

    public Type boltValueType() {
        return Type.DATE_TIME;
    }

    @Override
    public <T> T as(Class<T> targetClass) {
        if (targetClass.isAssignableFrom(ZonedDateTime.class)) {
            return targetClass.cast(this.asZonedDateTime());
        }
        if (targetClass.isAssignableFrom(OffsetDateTime.class)) {
            return targetClass.cast(this.asOffsetDateTime());
        }
        throw new Uncoercible(this.type().name(), targetClass.getCanonicalName());
    }
}

