/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver;

import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.neo4j.driver.BaseSession;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Query;
import org.neo4j.driver.QueryRunner;
import org.neo4j.driver.Result;
import org.neo4j.driver.Transaction;
import org.neo4j.driver.TransactionCallback;
import org.neo4j.driver.TransactionConfig;
import org.neo4j.driver.TransactionContext;
import org.neo4j.driver.util.Resource;

public interface Session
extends BaseSession,
Resource,
QueryRunner {
    public Transaction beginTransaction();

    public Transaction beginTransaction(TransactionConfig var1);

    default public <T> T executeRead(TransactionCallback<T> callback) {
        return this.executeRead(callback, TransactionConfig.empty());
    }

    public <T> T executeRead(TransactionCallback<T> var1, TransactionConfig var2);

    default public <T> T executeWrite(TransactionCallback<T> callback) {
        return this.executeWrite(callback, TransactionConfig.empty());
    }

    default public void executeWriteWithoutResult(Consumer<TransactionContext> contextConsumer) {
        this.executeWrite(tc -> {
            contextConsumer.accept(tc);
            return null;
        });
    }

    public <T> T executeWrite(TransactionCallback<T> var1, TransactionConfig var2);

    default public void executeWriteWithoutResult(Consumer<TransactionContext> contextConsumer, TransactionConfig config) {
        this.executeWrite(tc -> {
            contextConsumer.accept(tc);
            return null;
        }, config);
    }

    public Result run(String var1, TransactionConfig var2);

    public Result run(String var1, Map<String, Object> var2, TransactionConfig var3);

    public Result run(Query var1, TransactionConfig var2);

    public Set<Bookmark> lastBookmarks();

    @Override
    public void close();
}

