/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.handlers;

import io.netty.channel.Channel;
import io.netty.channel.ChannelPromise;
import java.util.Map;
import org.neo4j.driver.Value;
import org.neo4j.driver.exceptions.ProtocolException;
import org.neo4j.driver.internal.spi.ResponseHandler;

public class LogonResponseHandler
implements ResponseHandler {
    private final ChannelPromise connectionInitializedPromise;
    private final Channel channel;

    public LogonResponseHandler(ChannelPromise connectionInitializedPromise) {
        this.connectionInitializedPromise = connectionInitializedPromise;
        this.channel = connectionInitializedPromise.channel();
    }

    @Override
    public void onSuccess(Map<String, Value> metadata) {
        this.connectionInitializedPromise.setSuccess();
    }

    @Override
    public void onFailure(Throwable error) {
        this.channel.close().addListener(future -> this.connectionInitializedPromise.setFailure(error));
    }

    @Override
    public void onRecord(Value[] fields) {
        throw new ProtocolException("records not supported");
    }
}

