/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.io.Serializable;
import org.neo4j.driver.Config;

public class SecuritySettings
implements Serializable {
    private static final long serialVersionUID = 4494615367164106576L;
    private static final boolean DEFAULT_ENCRYPTED = false;
    private static final Config.TrustStrategy DEFAULT_TRUST_STRATEGY = Config.TrustStrategy.trustSystemCertificates();
    public static final SecuritySettings DEFAULT = new SecuritySettings(false, DEFAULT_TRUST_STRATEGY);
    private final boolean encrypted;
    private final Config.TrustStrategy trustStrategy;

    public SecuritySettings(boolean encrypted, Config.TrustStrategy trustStrategy) {
        this.encrypted = encrypted;
        this.trustStrategy = trustStrategy == null ? DEFAULT_TRUST_STRATEGY : trustStrategy;
    }

    public boolean encrypted() {
        return this.encrypted;
    }

    public Config.TrustStrategy trustStrategy() {
        return this.trustStrategy;
    }

    public static class SecuritySettingsBuilder {
        private boolean isCustomized = false;
        private boolean encrypted;
        private Config.TrustStrategy trustStrategy;

        public SecuritySettingsBuilder withEncryption() {
            this.encrypted = true;
            this.isCustomized = true;
            return this;
        }

        public SecuritySettingsBuilder withoutEncryption() {
            this.encrypted = false;
            this.isCustomized = true;
            return this;
        }

        public SecuritySettingsBuilder withTrustStrategy(Config.TrustStrategy strategy) {
            this.trustStrategy = strategy;
            this.isCustomized = true;
            return this;
        }

        public SecuritySettings build() {
            return this.isCustomized ? new SecuritySettings(this.encrypted, this.trustStrategy) : DEFAULT;
        }
    }
}

