/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.ResourceBundle;
import org.neo4j.driver.Logger;

public class BoltLogger
implements System.Logger {
    private final Logger logger;

    public BoltLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public String getName() {
        throw new RuntimeException(new UnsupportedOperationException("getName() not supported"));
    }

    @Override
    public boolean isLoggable(System.Logger.Level level) {
        return switch (level) {
            default -> throw new IncompatibleClassChangeError();
            case System.Logger.Level.ALL -> {
                if (this.logger.isTraceEnabled() && this.logger.isDebugEnabled()) {
                    yield true;
                }
                yield false;
            }
            case System.Logger.Level.TRACE -> this.logger.isTraceEnabled();
            case System.Logger.Level.DEBUG -> this.logger.isDebugEnabled();
            case System.Logger.Level.INFO, System.Logger.Level.WARNING, System.Logger.Level.ERROR -> true;
            case System.Logger.Level.OFF -> false;
        };
    }

    @Override
    public void log(System.Logger.Level level, ResourceBundle bundle, String msg, Throwable thrown) {
        switch (level) {
            case ALL: 
            case OFF: {
                break;
            }
            case TRACE: {
                this.logger.trace(msg, thrown);
                break;
            }
            case DEBUG: {
                this.logger.debug(msg, thrown);
                break;
            }
            case INFO: {
                this.logger.info(msg, thrown);
                break;
            }
            case WARNING: {
                this.logger.warn(msg, thrown);
                break;
            }
            case ERROR: {
                this.logger.error(msg, thrown);
            }
        }
    }

    @Override
    public void log(System.Logger.Level level, ResourceBundle bundle, String format, Object ... params) {
        switch (level) {
            case TRACE: {
                this.logger.trace(format, params);
                break;
            }
            case DEBUG: {
                this.logger.debug(format, params);
                break;
            }
            case INFO: {
                this.logger.info(format, params);
                break;
            }
            case WARNING: {
                this.logger.warn(format, params);
                break;
            }
        }
    }
}

