/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.adaptedbolt;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.neo4j.bolt.connection.AccessMode;
import org.neo4j.bolt.connection.AuthTokens;
import org.neo4j.bolt.connection.BoltAgent;
import org.neo4j.bolt.connection.BoltConnection;
import org.neo4j.bolt.connection.BoltConnectionProvider;
import org.neo4j.bolt.connection.BoltProtocolVersion;
import org.neo4j.bolt.connection.BoltServerAddress;
import org.neo4j.bolt.connection.DatabaseName;
import org.neo4j.bolt.connection.NotificationConfig;
import org.neo4j.bolt.connection.RoutingContext;
import org.neo4j.bolt.connection.SecurityPlan;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.adaptedbolt.AdaptingDriverBoltConnection;
import org.neo4j.driver.internal.adaptedbolt.DriverBoltConnection;
import org.neo4j.driver.internal.adaptedbolt.DriverBoltConnectionProvider;
import org.neo4j.driver.internal.adaptedbolt.ErrorMapper;
import org.neo4j.driver.internal.adaptedbolt.RoutedErrorMapper;
import org.neo4j.driver.internal.value.BoltValueFactory;

public class AdaptingDriverBoltConnectionProvider
implements DriverBoltConnectionProvider {
    private final BoltConnectionProvider delegate;
    private final ErrorMapper errorMapper;
    private final BoltValueFactory boltValueFactory;
    private final boolean routed;
    private final BoltServerAddress address;
    private final RoutingContext routingContext;
    private final BoltAgent boltAgent;
    private final String userAgent;
    private final int connectTimeoutMillis;

    public AdaptingDriverBoltConnectionProvider(BoltConnectionProvider delegate, ErrorMapper errorMapper, BoltValueFactory boltValueFactory, boolean routed, BoltServerAddress address, RoutingContext routingContext, BoltAgent boltAgent, String userAgent, int connectTimeoutMillis) {
        this.delegate = Objects.requireNonNull(delegate);
        this.errorMapper = Objects.requireNonNull(errorMapper);
        this.boltValueFactory = Objects.requireNonNull(boltValueFactory);
        this.routed = routed;
        this.address = Objects.requireNonNull(address);
        this.routingContext = Objects.requireNonNull(routingContext);
        this.boltAgent = Objects.requireNonNull(boltAgent);
        this.userAgent = Objects.requireNonNull(userAgent);
        this.connectTimeoutMillis = connectTimeoutMillis;
    }

    @Override
    public CompletionStage<DriverBoltConnection> connect(SecurityPlan securityPlan, DatabaseName databaseName, Supplier<CompletionStage<Map<String, Value>>> authMapStageSupplier, AccessMode mode, Set<String> bookmarks, String impersonatedUser, BoltProtocolVersion minVersion, NotificationConfig notificationConfig, Consumer<DatabaseName> databaseNameConsumer, Map<String, Object> additionalParameters) {
        return this.delegate.connect(this.address, this.routingContext, this.boltAgent, this.userAgent, this.connectTimeoutMillis, securityPlan, databaseName, () -> ((CompletionStage)authMapStageSupplier.get()).thenApply(map -> AuthTokens.custom(this.boltValueFactory.toBoltMap((Map<String, Value>)map))), mode, bookmarks, impersonatedUser, minVersion, notificationConfig, databaseNameConsumer, additionalParameters).exceptionally(this.errorMapper::mapAndTrow).thenApply(boltConnection -> new AdaptingDriverBoltConnection((BoltConnection)boltConnection, this.routed ? new RoutedErrorMapper(boltConnection.serverAddress(), mode) : this.errorMapper, this.boltValueFactory));
    }

    @Override
    public CompletionStage<Void> verifyConnectivity(SecurityPlan securityPlan, Map<String, Value> authMap) {
        return this.delegate.verifyConnectivity(this.address, this.routingContext, this.boltAgent, this.userAgent, this.connectTimeoutMillis, securityPlan, AuthTokens.custom(this.boltValueFactory.toBoltMap(authMap))).exceptionally(this.errorMapper::mapAndTrow);
    }

    @Override
    public CompletionStage<Boolean> supportsMultiDb(SecurityPlan securityPlan, Map<String, Value> authMap) {
        return this.delegate.supportsMultiDb(this.address, this.routingContext, this.boltAgent, this.userAgent, this.connectTimeoutMillis, securityPlan, AuthTokens.custom(this.boltValueFactory.toBoltMap(authMap))).exceptionally(this.errorMapper::mapAndTrow);
    }

    @Override
    public CompletionStage<Boolean> supportsSessionAuth(SecurityPlan securityPlan, Map<String, Value> authMap) {
        return this.delegate.supportsSessionAuth(this.address, this.routingContext, this.boltAgent, this.userAgent, this.connectTimeoutMillis, securityPlan, AuthTokens.custom(this.boltValueFactory.toBoltMap(authMap))).exceptionally(this.errorMapper::mapAndTrow);
    }

    @Override
    public CompletionStage<Void> close() {
        return this.delegate.close().exceptionally(this.errorMapper::mapAndTrow);
    }
}

