/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.telemetry;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import org.neo4j.driver.internal.adaptedbolt.DriverBoltConnection;
import org.neo4j.driver.internal.bolt.api.TelemetryApi;

public record ApiTelemetryWork(TelemetryApi telemetryApi, AtomicBoolean enabled, AtomicBoolean acknowledged) {
    public ApiTelemetryWork(TelemetryApi telemetryApi) {
        this(telemetryApi, new AtomicBoolean(), new AtomicBoolean());
    }

    public void setEnabled(boolean enabled) {
        this.enabled.set(enabled);
    }

    public void acknowledge() {
        this.acknowledged.set(true);
    }

    public CompletionStage<DriverBoltConnection> pipelineTelemetryIfEnabled(DriverBoltConnection connection) {
        if (this.enabled.get() && connection.telemetrySupported() && !this.acknowledged.get()) {
            return connection.telemetry(this.telemetryApi);
        }
        return CompletableFuture.completedStage(connection);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiTelemetryWork that = (ApiTelemetryWork)o;
        return Objects.equals(this.enabled.get(), that.enabled.get()) && this.telemetryApi == that.telemetryApi && Objects.equals(this.acknowledged.get(), that.acknowledged.get());
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.telemetryApi, this.enabled.get(), this.acknowledged.get()});
    }
}

