/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.bolt.routedimpl;

import java.time.Clock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.net.ssl.SSLHandshakeException;
import org.neo4j.driver.internal.bolt.api.AccessMode;
import org.neo4j.driver.internal.bolt.api.AuthToken;
import org.neo4j.driver.internal.bolt.api.BoltAgent;
import org.neo4j.driver.internal.bolt.api.BoltConnection;
import org.neo4j.driver.internal.bolt.api.BoltConnectionProvider;
import org.neo4j.driver.internal.bolt.api.BoltProtocolVersion;
import org.neo4j.driver.internal.bolt.api.BoltServerAddress;
import org.neo4j.driver.internal.bolt.api.DatabaseName;
import org.neo4j.driver.internal.bolt.api.DatabaseNameUtil;
import org.neo4j.driver.internal.bolt.api.DomainNameResolver;
import org.neo4j.driver.internal.bolt.api.LoggingProvider;
import org.neo4j.driver.internal.bolt.api.MetricsListener;
import org.neo4j.driver.internal.bolt.api.NotificationConfig;
import org.neo4j.driver.internal.bolt.api.RoutingContext;
import org.neo4j.driver.internal.bolt.api.SecurityPlan;
import org.neo4j.driver.internal.bolt.api.exception.BoltConnectionAcquisitionException;
import org.neo4j.driver.internal.bolt.api.exception.BoltFailureException;
import org.neo4j.driver.internal.bolt.api.exception.BoltServiceUnavailableException;
import org.neo4j.driver.internal.bolt.routedimpl.Rediscovery;
import org.neo4j.driver.internal.bolt.routedimpl.RoutingTable;
import org.neo4j.driver.internal.bolt.routedimpl.impl.AuthTokenManagerExecutionException;
import org.neo4j.driver.internal.bolt.routedimpl.impl.RoutedBoltConnection;
import org.neo4j.driver.internal.bolt.routedimpl.impl.cluster.RediscoveryImpl;
import org.neo4j.driver.internal.bolt.routedimpl.impl.cluster.RoutingTableHandler;
import org.neo4j.driver.internal.bolt.routedimpl.impl.cluster.RoutingTableRegistry;
import org.neo4j.driver.internal.bolt.routedimpl.impl.cluster.RoutingTableRegistryImpl;
import org.neo4j.driver.internal.bolt.routedimpl.impl.cluster.loadbalancing.LeastConnectedLoadBalancingStrategy;
import org.neo4j.driver.internal.bolt.routedimpl.impl.cluster.loadbalancing.LoadBalancingStrategy;
import org.neo4j.driver.internal.bolt.routedimpl.impl.util.FutureUtil;

public class RoutedBoltConnectionProvider
implements BoltConnectionProvider {
    private static final String CONNECTION_ACQUISITION_COMPLETION_FAILURE_MESSAGE = "Connection acquisition failed for all available addresses.";
    private static final String CONNECTION_ACQUISITION_COMPLETION_EXCEPTION_MESSAGE = "Failed to obtain connection towards %s server. Known routing table is: %s";
    private static final String CONNECTION_ACQUISITION_ATTEMPT_FAILURE_MESSAGE = "Failed to obtain a connection towards address %s, will try other addresses if available. Complete failure is reported separately from this entry.";
    private final System.Logger log;
    private final Function<BoltServerAddress, BoltConnectionProvider> boltConnectionProviderFunction;
    private final Map<BoltServerAddress, BoltConnectionProvider> addressToProvider = new HashMap<BoltServerAddress, BoltConnectionProvider>();
    private final Map<BoltServerAddress, Integer> addressToInUseCount = new HashMap<BoltServerAddress, Integer>();
    private final LoadBalancingStrategy loadBalancingStrategy;
    private final RoutingTableRegistry registry;
    private final RoutingContext routingContext;
    private final BoltAgent boltAgent;
    private final String userAgent;
    private final int connectTimeoutMillis;
    private Rediscovery rediscovery;
    private CompletableFuture<Void> closeFuture;

    public RoutedBoltConnectionProvider(Function<BoltServerAddress, BoltConnectionProvider> boltConnectionProviderFunction, Function<BoltServerAddress, Set<BoltServerAddress>> resolver, DomainNameResolver domainNameResolver, long routingTablePurgeDelayMs, Rediscovery rediscovery, Clock clock, LoggingProvider logging, BoltServerAddress address, RoutingContext routingContext, BoltAgent boltAgent, String userAgent, int connectTimeoutMillis, MetricsListener metricsListener) {
        this.boltConnectionProviderFunction = Objects.requireNonNull(boltConnectionProviderFunction);
        this.log = logging.getLog(this.getClass());
        this.loadBalancingStrategy = new LeastConnectedLoadBalancingStrategy(this::getInUseCount, logging);
        this.rediscovery = rediscovery;
        this.routingContext = routingContext;
        this.boltAgent = boltAgent;
        this.userAgent = userAgent;
        this.connectTimeoutMillis = connectTimeoutMillis;
        if (this.rediscovery == null) {
            this.rediscovery = new RediscoveryImpl(address, resolver, logging, domainNameResolver, routingContext, boltAgent, userAgent, connectTimeoutMillis);
        }
        this.registry = new RoutingTableRegistryImpl(this::get, this.rediscovery, clock, logging, routingTablePurgeDelayMs, this::shutdownUnusedProviders);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<BoltConnection> connect(BoltServerAddress ignoredAddress, RoutingContext ignoredRoutingContext, BoltAgent ignoredBoltAgent, String ignoredUserAgent, int ignoredConnectTimeoutMillis, SecurityPlan securityPlan, DatabaseName databaseName, Supplier<CompletionStage<AuthToken>> authTokenStageSupplier, AccessMode mode, Set<String> bookmarks, String impersonatedUser, BoltProtocolVersion minVersion, NotificationConfig notificationConfig, Consumer<DatabaseName> databaseNameConsumer, Map<String, Object> additionalParameters) {
        RoutingTableRegistry registry;
        Object homeDatabaseHintObj = additionalParameters.get("homeDatabase");
        String homeDatabaseHint = homeDatabaseHintObj instanceof String ? (String)homeDatabaseHintObj : null;
        RoutedBoltConnectionProvider routedBoltConnectionProvider = this;
        synchronized (routedBoltConnectionProvider) {
            if (this.closeFuture != null) {
                return CompletableFuture.failedFuture(new IllegalStateException("Connection provider is closed."));
            }
            registry = this.registry;
        }
        Supplier<CompletionStage<AuthToken>> supplier = () -> ((CompletionStage)authTokenStageSupplier.get()).exceptionally(throwable -> {
            throw new AuthTokenManagerExecutionException((Throwable)throwable);
        });
        AtomicReference handlerRef = new AtomicReference();
        CompletableFuture<DatabaseName> databaseNameFuture = databaseName == null ? new CompletableFuture<DatabaseName>() : CompletableFuture.completedFuture(databaseName);
        databaseNameFuture.whenComplete((name, throwable) -> {
            if (name != null) {
                databaseNameConsumer.accept((DatabaseName)name);
            }
        });
        return registry.ensureRoutingTable(securityPlan, databaseNameFuture, mode, bookmarks, impersonatedUser, supplier, minVersion, homeDatabaseHint).thenApply(routingTableHandler -> {
            handlerRef.set(routingTableHandler);
            return routingTableHandler;
        }).thenCompose(routingTableHandler -> this.acquire(securityPlan, mode, routingTableHandler.routingTable(), supplier, routingTableHandler.routingTable().database(), Set.of(), impersonatedUser, minVersion, notificationConfig)).thenApply(boltConnection -> new RoutedBoltConnection((BoltConnection)boltConnection, (RoutingTableHandler)handlerRef.get(), mode, this)).exceptionally(throwable -> {
            if ((throwable = FutureUtil.completionExceptionCause(throwable)) instanceof AuthTokenManagerExecutionException) {
                throwable = throwable.getCause();
            }
            if (throwable instanceof RuntimeException) {
                RuntimeException runtimeException = (RuntimeException)throwable;
                throw runtimeException;
            }
            throw new CompletionException((Throwable)throwable);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<Void> verifyConnectivity(BoltServerAddress ignoredAddress, RoutingContext ignoredRoutingContext, BoltAgent ignoredBoltAgent, String ignoredUserAgent, int ignoredConnectTimeoutMillis, SecurityPlan securityPlan, AuthToken authToken) {
        RoutingTableRegistry registry;
        RoutedBoltConnectionProvider routedBoltConnectionProvider = this;
        synchronized (routedBoltConnectionProvider) {
            registry = this.registry;
        }
        return this.supportsMultiDb(null, null, null, null, 0, securityPlan, authToken).thenCompose(supports -> registry.ensureRoutingTable(securityPlan, supports != false ? CompletableFuture.completedFuture(DatabaseNameUtil.database("system")) : CompletableFuture.completedFuture(DatabaseNameUtil.defaultDatabase()), AccessMode.READ, Collections.emptySet(), null, () -> CompletableFuture.completedStage(authToken), null, null)).handle((ignored, error) -> {
            if (error != null) {
                Throwable cause = FutureUtil.completionExceptionCause(error);
                if (cause instanceof BoltServiceUnavailableException) {
                    throw FutureUtil.asCompletionException(new BoltServiceUnavailableException("Unable to connect to database management service, ensure the database is running and that there is a working network connection to it.", cause));
                }
                throw FutureUtil.asCompletionException(cause);
            }
            return null;
        });
    }

    @Override
    public CompletionStage<Boolean> supportsMultiDb(BoltServerAddress ignoredAddress, RoutingContext ignoredRoutingContext, BoltAgent ignoredBoltAgent, String ignoredUserAgent, int ignoredConnectTimeoutMillis, SecurityPlan securityPlan, AuthToken authToken) {
        return this.detectFeature(securityPlan, authToken, "Failed to perform multi-databases feature detection with the following servers: ", boltConnection -> boltConnection.protocolVersion().compareTo(new BoltProtocolVersion(4, 0)) >= 0);
    }

    @Override
    public CompletionStage<Boolean> supportsSessionAuth(BoltServerAddress ignoredAddress, RoutingContext ignoredRoutingContext, BoltAgent ignoredBoltAgent, String ignoredUserAgent, int ignoredConnectTimeoutMillis, SecurityPlan securityPlan, AuthToken authToken) {
        return this.detectFeature(securityPlan, authToken, "Failed to perform session auth feature detection with the following servers: ", boltConnection -> new BoltProtocolVersion(5, 1).compareTo(boltConnection.protocolVersion()) <= 0);
    }

    private synchronized void shutdownUnusedProviders(Set<BoltServerAddress> addressesToRetain) {
        Iterator<Map.Entry<BoltServerAddress, BoltConnectionProvider>> iterator = this.addressToProvider.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<BoltServerAddress, BoltConnectionProvider> entry = iterator.next();
            BoltServerAddress address = entry.getKey();
            if (addressesToRetain.contains(address) || this.getInUseCount(address) != 0) continue;
            entry.getValue().close();
            iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletionStage<Boolean> detectFeature(SecurityPlan securityPlan, AuthToken authToken, String baseErrorMessagePrefix, Function<BoltConnection, Boolean> featureDetectionFunction) {
        List<BoltServerAddress> addresses;
        Rediscovery rediscovery;
        RoutedBoltConnectionProvider routedBoltConnectionProvider = this;
        synchronized (routedBoltConnectionProvider) {
            rediscovery = this.rediscovery;
        }
        try {
            addresses = rediscovery.resolve();
        }
        catch (Throwable error) {
            return CompletableFuture.failedFuture(error);
        }
        CompletableFuture<Object> result = CompletableFuture.completedFuture(null);
        BoltServiceUnavailableException baseError = new BoltServiceUnavailableException(baseErrorMessagePrefix + addresses);
        Function<BoltFailureException, Boolean> isSecurityException = boltFailureException -> boltFailureException.code().startsWith("Neo.ClientError.Security.");
        for (BoltServerAddress address : addresses) {
            result = FutureUtil.onErrorContinue(result, baseError, completionError -> {
                BoltFailureException boltFailureException;
                Throwable error = FutureUtil.completionExceptionCause(completionError);
                if (error instanceof BoltFailureException ? (Boolean)isSecurityException.apply(boltFailureException = (BoltFailureException)error) != false : error instanceof SSLHandshakeException) {
                    return CompletableFuture.failedFuture(error);
                }
                return this.get(address).connect(address, this.routingContext, this.boltAgent, this.userAgent, this.connectTimeoutMillis, securityPlan, null, () -> CompletableFuture.completedStage(authToken), AccessMode.WRITE, Collections.emptySet(), null, null, null, ignored -> {}, Collections.emptyMap()).thenCompose(boltConnection -> {
                    Boolean featureDetected = (Boolean)featureDetectionFunction.apply((BoltConnection)boltConnection);
                    return boltConnection.close().thenApply(ignored -> featureDetected);
                });
            });
        }
        return FutureUtil.onErrorContinue(result, baseError, completionError -> {
            BoltFailureException boltFailureException;
            Throwable error = FutureUtil.completionExceptionCause(completionError);
            if (error instanceof BoltFailureException ? (Boolean)isSecurityException.apply(boltFailureException = (BoltFailureException)error) != false : error instanceof SSLHandshakeException) {
                return CompletableFuture.failedFuture(error);
            }
            return CompletableFuture.failedFuture(baseError);
        });
    }

    private CompletionStage<BoltConnection> acquire(SecurityPlan securityPlan, AccessMode mode, RoutingTable routingTable, Supplier<CompletionStage<AuthToken>> authTokenStageSupplier, DatabaseName database, Set<String> bookmarks, String impersonatedUser, BoltProtocolVersion minVersion, NotificationConfig notificationConfig) {
        CompletableFuture<BoltConnection> result = new CompletableFuture<BoltConnection>();
        ArrayList<Throwable> attemptExceptions = new ArrayList<Throwable>();
        this.acquire(securityPlan, mode, routingTable, result, authTokenStageSupplier, attemptExceptions, database, bookmarks, impersonatedUser, minVersion, notificationConfig);
        return result;
    }

    private void acquire(SecurityPlan securityPlan, AccessMode mode, RoutingTable routingTable, CompletableFuture<BoltConnection> result, Supplier<CompletionStage<AuthToken>> authTokenStageSupplier, List<Throwable> attemptErrors, DatabaseName database, Set<String> bookmarks, String impersonatedUser, BoltProtocolVersion minVersion, NotificationConfig notificationConfig) {
        List<BoltServerAddress> addresses = RoutedBoltConnectionProvider.getAddressesByMode(mode, routingTable);
        this.log.log(System.Logger.Level.DEBUG, "Addresses: " + addresses);
        BoltServerAddress address = this.selectAddress(mode, addresses);
        this.log.log(System.Logger.Level.DEBUG, "Selected address: " + address);
        if (address == null) {
            BoltConnectionAcquisitionException completionError2 = new BoltConnectionAcquisitionException(String.format(CONNECTION_ACQUISITION_COMPLETION_EXCEPTION_MESSAGE, new Object[]{mode, routingTable}));
            attemptErrors.forEach(completionError2::addSuppressed);
            this.log.log(System.Logger.Level.ERROR, CONNECTION_ACQUISITION_COMPLETION_FAILURE_MESSAGE, (Throwable)completionError2);
            result.completeExceptionally(completionError2);
            return;
        }
        this.get(address).connect(address, this.routingContext, this.boltAgent, this.userAgent, this.connectTimeoutMillis, securityPlan, database, authTokenStageSupplier, mode, bookmarks, impersonatedUser, minVersion, notificationConfig, ignored -> {}, Collections.emptyMap()).whenComplete((connection, completionError) -> {
            Throwable error = FutureUtil.completionExceptionCause(completionError);
            if (error != null) {
                if (error instanceof BoltServiceUnavailableException) {
                    String attemptMessage = String.format(CONNECTION_ACQUISITION_ATTEMPT_FAILURE_MESSAGE, address);
                    this.log.log(System.Logger.Level.WARNING, attemptMessage);
                    this.log.log(System.Logger.Level.DEBUG, attemptMessage, error);
                    attemptErrors.add(error);
                    routingTable.forget(address);
                    CompletableFuture.runAsync(() -> this.lambda$acquire$20(securityPlan, mode, routingTable, result, (Supplier)authTokenStageSupplier, attemptErrors, database, bookmarks, impersonatedUser, minVersion, notificationConfig));
                } else {
                    result.completeExceptionally(error);
                }
            } else {
                this.incrementInUseCount(address);
                result.complete((BoltConnection)connection);
            }
        });
    }

    private BoltServerAddress selectAddress(AccessMode mode, List<BoltServerAddress> addresses) {
        return switch (mode) {
            default -> throw new IncompatibleClassChangeError();
            case AccessMode.READ -> this.loadBalancingStrategy.selectReader(addresses);
            case AccessMode.WRITE -> this.loadBalancingStrategy.selectWriter(addresses);
        };
    }

    private static List<BoltServerAddress> getAddressesByMode(AccessMode mode, RoutingTable routingTable) {
        return switch (mode) {
            default -> throw new IncompatibleClassChangeError();
            case AccessMode.READ -> routingTable.readers();
            case AccessMode.WRITE -> routingTable.writers();
        };
    }

    private synchronized int getInUseCount(BoltServerAddress address) {
        return this.addressToInUseCount.getOrDefault(address, 0);
    }

    private synchronized void incrementInUseCount(BoltServerAddress address) {
        this.addressToInUseCount.merge(address, 1, Integer::sum);
    }

    public synchronized void decrementInUseCount(BoltServerAddress address) {
        this.addressToInUseCount.compute(address, (ignored, value) -> {
            if (value == null) {
                return null;
            }
            Integer n = value;
            value = value - 1;
            return value > 0 ? value : null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<Void> close() {
        CompletableFuture<Void> closeFuture;
        RoutedBoltConnectionProvider routedBoltConnectionProvider = this;
        synchronized (routedBoltConnectionProvider) {
            if (this.closeFuture == null) {
                CompletableFuture[] futures = new CompletableFuture[this.addressToProvider.size()];
                Iterator<BoltConnectionProvider> iterator = this.addressToProvider.values().iterator();
                int index = 0;
                while (iterator.hasNext()) {
                    futures[index++] = iterator.next().close().toCompletableFuture();
                    iterator.remove();
                }
                this.closeFuture = CompletableFuture.allOf(futures);
            }
            closeFuture = this.closeFuture;
        }
        return closeFuture;
    }

    private synchronized BoltConnectionProvider get(BoltServerAddress address) {
        BoltConnectionProvider provider = this.addressToProvider.get(address);
        if (provider == null) {
            provider = this.boltConnectionProviderFunction.apply(address);
            this.addressToProvider.put(address, provider);
        }
        return provider;
    }

    private /* synthetic */ void lambda$acquire$20(SecurityPlan securityPlan, AccessMode mode, RoutingTable routingTable, CompletableFuture result, Supplier authTokenStageSupplier, List attemptErrors, DatabaseName database, Set bookmarks, String impersonatedUser, BoltProtocolVersion minVersion, NotificationConfig notificationConfig) {
        this.acquire(securityPlan, mode, routingTable, result, authTokenStageSupplier, attemptErrors, database, bookmarks, impersonatedUser, minVersion, notificationConfig);
    }
}

