/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.bolt.basicimpl.handlers;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.neo4j.driver.internal.bolt.api.values.Value;
import org.neo4j.driver.internal.bolt.basicimpl.spi.ResponseHandler;

public class ResetResponseHandler
implements ResponseHandler {
    private final CompletableFuture<Void> completionFuture;
    private final Throwable throwable;

    public ResetResponseHandler(CompletableFuture<Void> completionFuture) {
        this(completionFuture, null);
    }

    public ResetResponseHandler(CompletableFuture<Void> completionFuture, Throwable throwable) {
        this.completionFuture = completionFuture;
        this.throwable = throwable;
    }

    @Override
    public final void onSuccess(Map<String, Value> metadata) {
        this.resetCompleted();
    }

    @Override
    public final void onFailure(Throwable error) {
        if (this.completionFuture != null) {
            this.completionFuture.completeExceptionally(error);
        }
    }

    @Override
    public final void onRecord(Value[] fields) {
        throw new UnsupportedOperationException();
    }

    public Optional<Throwable> throwable() {
        return Optional.ofNullable(this.throwable);
    }

    private void resetCompleted() {
        if (this.completionFuture != null) {
            this.completionFuture.complete(null);
        }
    }
}

