/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.bolt.basicimpl.handlers;

import io.netty.channel.Channel;
import java.time.Clock;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.neo4j.driver.internal.bolt.api.exception.BoltProtocolException;
import org.neo4j.driver.internal.bolt.api.values.Value;
import org.neo4j.driver.internal.bolt.basicimpl.spi.ResponseHandler;

public class LogonResponseHandler
implements ResponseHandler {
    private final CompletableFuture<?> future;
    private final Channel channel;
    private final Clock clock;
    private final CompletableFuture<Long> latestAuthMillisFuture;

    public LogonResponseHandler(CompletableFuture<?> future, Channel channel, Clock clock, CompletableFuture<Long> latestAuthMillisFuture) {
        this.future = Objects.requireNonNull(future, "future must not be null");
        this.channel = channel;
        this.clock = Objects.requireNonNull(clock, "clock must not be null");
        this.latestAuthMillisFuture = Objects.requireNonNull(latestAuthMillisFuture);
    }

    @Override
    public void onSuccess(Map<String, Value> metadata) {
        this.latestAuthMillisFuture.complete(this.clock.millis());
        this.future.complete(null);
    }

    @Override
    public void onFailure(Throwable error) {
        if (this.channel != null) {
            this.channel.close().addListener(future -> this.future.completeExceptionally(error));
        } else {
            this.future.completeExceptionally(error);
        }
    }

    @Override
    public void onRecord(Value[] fields) {
        this.future.completeExceptionally(new BoltProtocolException("Records are not supported on LOGON"));
    }
}

