/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.Set;
import java.util.stream.Collectors;
import org.neo4j.driver.NotificationCategory;
import org.neo4j.driver.NotificationConfig;
import org.neo4j.driver.NotificationSeverity;
import org.neo4j.driver.internal.InternalNotificationConfig;
import org.neo4j.driver.internal.InternalNotificationSeverity;
import org.neo4j.driver.internal.bolt.api.NotificationClassification;

public class NotificationConfigMapper {
    public static org.neo4j.driver.internal.bolt.api.NotificationConfig map(NotificationConfig config) {
        InternalNotificationConfig original = (InternalNotificationConfig)config;
        Set<NotificationCategory> disabledCategories = original.disabledCategories();
        return new org.neo4j.driver.internal.bolt.api.NotificationConfig(NotificationConfigMapper.map(original.minimumSeverity()), disabledCategories != null ? disabledCategories.stream().map(NotificationConfigMapper::map).collect(Collectors.toSet()) : null);
    }

    private static org.neo4j.driver.internal.bolt.api.NotificationSeverity map(NotificationSeverity severity) {
        if (severity == null) {
            return null;
        }
        InternalNotificationSeverity original = (InternalNotificationSeverity)severity;
        return switch (original.type()) {
            default -> throw new IncompatibleClassChangeError();
            case InternalNotificationSeverity.Type.INFORMATION -> org.neo4j.driver.internal.bolt.api.NotificationSeverity.INFORMATION;
            case InternalNotificationSeverity.Type.WARNING -> org.neo4j.driver.internal.bolt.api.NotificationSeverity.WARNING;
            case InternalNotificationSeverity.Type.OFF -> org.neo4j.driver.internal.bolt.api.NotificationSeverity.OFF;
        };
    }

    private static NotificationClassification map(NotificationCategory category) {
        if (category == null) {
            return null;
        }
        org.neo4j.driver.NotificationClassification original = (org.neo4j.driver.NotificationClassification)category;
        return switch (original) {
            default -> throw new IncompatibleClassChangeError();
            case org.neo4j.driver.NotificationClassification.HINT -> new NotificationClassification(NotificationClassification.Type.HINT);
            case org.neo4j.driver.NotificationClassification.UNRECOGNIZED -> new NotificationClassification(NotificationClassification.Type.UNRECOGNIZED);
            case org.neo4j.driver.NotificationClassification.UNSUPPORTED -> new NotificationClassification(NotificationClassification.Type.UNSUPPORTED);
            case org.neo4j.driver.NotificationClassification.PERFORMANCE -> new NotificationClassification(NotificationClassification.Type.PERFORMANCE);
            case org.neo4j.driver.NotificationClassification.DEPRECATION -> new NotificationClassification(NotificationClassification.Type.DEPRECATION);
            case org.neo4j.driver.NotificationClassification.SECURITY -> new NotificationClassification(NotificationClassification.Type.SECURITY);
            case org.neo4j.driver.NotificationClassification.TOPOLOGY -> new NotificationClassification(NotificationClassification.Type.TOPOLOGY);
            case org.neo4j.driver.NotificationClassification.GENERIC -> new NotificationClassification(NotificationClassification.Type.GENERIC);
            case org.neo4j.driver.NotificationClassification.SCHEMA -> new NotificationClassification(NotificationClassification.Type.SCHEMA);
        };
    }
}

