/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.summary;

import java.util.Optional;
import org.neo4j.driver.NotificationCategory;
import org.neo4j.driver.NotificationClassification;
import org.neo4j.driver.NotificationSeverity;
import org.neo4j.driver.summary.GqlStatusObject;
import org.neo4j.driver.summary.InputPosition;
import org.neo4j.driver.util.Immutable;
import org.neo4j.driver.util.Preview;

@Immutable
public interface Notification
extends GqlStatusObject {
    public String code();

    public String title();

    public String description();

    public InputPosition position();

    @Preview(name="GQL-status object")
    default public Optional<InputPosition> inputPosition() {
        return Optional.ofNullable(this.position());
    }

    @Deprecated
    default public String severity() {
        return this.rawSeverityLevel().orElse("N/A");
    }

    default public Optional<NotificationSeverity> severityLevel() {
        return Optional.empty();
    }

    default public Optional<String> rawSeverityLevel() {
        return Optional.empty();
    }

    @Preview(name="GQL-status object")
    default public Optional<NotificationClassification> classification() {
        return Optional.empty();
    }

    @Preview(name="GQL-status object")
    default public Optional<String> rawClassification() {
        return Optional.empty();
    }

    default public Optional<NotificationCategory> category() {
        return Optional.empty();
    }

    default public Optional<String> rawCategory() {
        return Optional.empty();
    }
}

