/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cursor;

import java.util.List;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.internal.bolt.api.GqlStatusError;
import org.neo4j.driver.internal.summary.InternalGqlStatusObject;
import org.neo4j.driver.summary.GqlStatusObject;

public abstract class AbstractRecordStateResponseHandler {
    protected RecordState recordState = RecordState.NOT_REQUESTED;

    protected synchronized GqlStatusObject generateGqlStatusObject(List<String> keys) {
        return switch (this.recordState) {
            default -> throw new IncompatibleClassChangeError();
            case RecordState.NOT_REQUESTED -> {
                if (keys.isEmpty()) {
                    yield InternalGqlStatusObject.OMITTED_RESULT;
                }
                yield InternalGqlStatusObject.NO_DATA_UNKNOWN;
            }
            case RecordState.HAD_RECORD -> InternalGqlStatusObject.SUCCESS;
            case RecordState.REQUESTED -> {
                String message = "Unexpected state: " + this.recordState;
                throw new ClientException(GqlStatusError.UNKNOWN.getStatus(), GqlStatusError.UNKNOWN.getStatusDescription(message), "N/A", message, GqlStatusError.DIAGNOSTIC_RECORD, null);
            }
            case RecordState.NO_RECORD -> keys.isEmpty() ? InternalGqlStatusObject.OMITTED_RESULT : InternalGqlStatusObject.NO_DATA;
        };
    }

    protected void updateRecordState(RecordState recordState) {
        if (recordState.ordinal() > this.recordState.ordinal()) {
            this.recordState = recordState;
        }
    }

    protected static enum RecordState {
        NOT_REQUESTED,
        REQUESTED,
        NO_RECORD,
        HAD_RECORD;

    }
}

