/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.bolt.basicimpl.messaging;

import io.netty.channel.Channel;
import java.time.Clock;
import java.time.Duration;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.neo4j.driver.Value;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.exceptions.UnsupportedFeatureException;
import org.neo4j.driver.internal.bolt.api.AccessMode;
import org.neo4j.driver.internal.bolt.api.BoltAgent;
import org.neo4j.driver.internal.bolt.api.BoltProtocolVersion;
import org.neo4j.driver.internal.bolt.api.DatabaseName;
import org.neo4j.driver.internal.bolt.api.GqlStatusError;
import org.neo4j.driver.internal.bolt.api.LoggingProvider;
import org.neo4j.driver.internal.bolt.api.NotificationConfig;
import org.neo4j.driver.internal.bolt.api.RoutingContext;
import org.neo4j.driver.internal.bolt.api.summary.DiscardSummary;
import org.neo4j.driver.internal.bolt.api.summary.RouteSummary;
import org.neo4j.driver.internal.bolt.api.summary.RunSummary;
import org.neo4j.driver.internal.bolt.basicimpl.async.connection.ChannelAttributes;
import org.neo4j.driver.internal.bolt.basicimpl.messaging.MessageFormat;
import org.neo4j.driver.internal.bolt.basicimpl.messaging.MessageHandler;
import org.neo4j.driver.internal.bolt.basicimpl.messaging.PullMessageHandler;
import org.neo4j.driver.internal.bolt.basicimpl.messaging.v3.BoltProtocolV3;
import org.neo4j.driver.internal.bolt.basicimpl.messaging.v4.BoltProtocolV4;
import org.neo4j.driver.internal.bolt.basicimpl.messaging.v41.BoltProtocolV41;
import org.neo4j.driver.internal.bolt.basicimpl.messaging.v42.BoltProtocolV42;
import org.neo4j.driver.internal.bolt.basicimpl.messaging.v43.BoltProtocolV43;
import org.neo4j.driver.internal.bolt.basicimpl.messaging.v44.BoltProtocolV44;
import org.neo4j.driver.internal.bolt.basicimpl.messaging.v5.BoltProtocolV5;
import org.neo4j.driver.internal.bolt.basicimpl.messaging.v51.BoltProtocolV51;
import org.neo4j.driver.internal.bolt.basicimpl.messaging.v52.BoltProtocolV52;
import org.neo4j.driver.internal.bolt.basicimpl.messaging.v53.BoltProtocolV53;
import org.neo4j.driver.internal.bolt.basicimpl.messaging.v54.BoltProtocolV54;
import org.neo4j.driver.internal.bolt.basicimpl.messaging.v55.BoltProtocolV55;
import org.neo4j.driver.internal.bolt.basicimpl.messaging.v56.BoltProtocolV56;
import org.neo4j.driver.internal.bolt.basicimpl.messaging.v57.BoltProtocolV57;
import org.neo4j.driver.internal.bolt.basicimpl.spi.Connection;

public interface BoltProtocol {
    public MessageFormat createMessageFormat();

    public CompletionStage<Channel> initializeChannel(Channel var1, String var2, BoltAgent var3, Map<String, Value> var4, RoutingContext var5, NotificationConfig var6, Clock var7, CompletableFuture<Long> var8);

    public CompletionStage<Void> route(Connection var1, Map<String, Value> var2, Set<String> var3, String var4, String var5, MessageHandler<RouteSummary> var6, Clock var7, LoggingProvider var8);

    public CompletionStage<Void> beginTransaction(Connection var1, DatabaseName var2, AccessMode var3, String var4, Set<String> var5, Duration var6, Map<String, Value> var7, String var8, NotificationConfig var9, MessageHandler<Void> var10, LoggingProvider var11);

    public CompletionStage<Void> commitTransaction(Connection var1, MessageHandler<String> var2);

    public CompletionStage<Void> rollbackTransaction(Connection var1, MessageHandler<Void> var2);

    public CompletionStage<Void> telemetry(Connection var1, Integer var2, MessageHandler<Void> var3);

    public CompletionStage<Void> runAuto(Connection var1, DatabaseName var2, AccessMode var3, String var4, String var5, Map<String, Value> var6, Set<String> var7, Duration var8, Map<String, Value> var9, NotificationConfig var10, MessageHandler<RunSummary> var11, LoggingProvider var12);

    public CompletionStage<Void> run(Connection var1, String var2, Map<String, Value> var3, MessageHandler<RunSummary> var4);

    public CompletionStage<Void> pull(Connection var1, long var2, long var4, PullMessageHandler var6);

    public CompletionStage<Void> discard(Connection var1, long var2, long var4, MessageHandler<DiscardSummary> var6);

    public CompletionStage<Void> reset(Connection var1, MessageHandler<Void> var2);

    default public CompletionStage<Void> logoff(Connection connection, MessageHandler<Void> handler) {
        return CompletableFuture.failedStage(new UnsupportedFeatureException("logoff not supported"));
    }

    default public CompletionStage<Void> logon(Connection connection, Map<String, Value> authMap, Clock clock, MessageHandler<Void> handler) {
        return CompletableFuture.failedStage(new UnsupportedFeatureException("logon not supported"));
    }

    public BoltProtocolVersion version();

    public static BoltProtocol forChannel(Channel channel) {
        return BoltProtocol.forVersion(ChannelAttributes.protocolVersion(channel));
    }

    public static BoltProtocol forVersion(BoltProtocolVersion version) {
        if (BoltProtocolV3.VERSION.equals(version)) {
            return BoltProtocolV3.INSTANCE;
        }
        if (BoltProtocolV4.VERSION.equals(version)) {
            return BoltProtocolV4.INSTANCE;
        }
        if (BoltProtocolV41.VERSION.equals(version)) {
            return BoltProtocolV41.INSTANCE;
        }
        if (BoltProtocolV42.VERSION.equals(version)) {
            return BoltProtocolV42.INSTANCE;
        }
        if (BoltProtocolV43.VERSION.equals(version)) {
            return BoltProtocolV43.INSTANCE;
        }
        if (BoltProtocolV44.VERSION.equals(version)) {
            return BoltProtocolV44.INSTANCE;
        }
        if (BoltProtocolV5.VERSION.equals(version)) {
            return BoltProtocolV5.INSTANCE;
        }
        if (BoltProtocolV51.VERSION.equals(version)) {
            return BoltProtocolV51.INSTANCE;
        }
        if (BoltProtocolV52.VERSION.equals(version)) {
            return BoltProtocolV52.INSTANCE;
        }
        if (BoltProtocolV53.VERSION.equals(version)) {
            return BoltProtocolV53.INSTANCE;
        }
        if (BoltProtocolV54.VERSION.equals(version)) {
            return BoltProtocolV54.INSTANCE;
        }
        if (BoltProtocolV55.VERSION.equals(version)) {
            return BoltProtocolV55.INSTANCE;
        }
        if (BoltProtocolV56.VERSION.equals(version)) {
            return BoltProtocolV56.INSTANCE;
        }
        if (BoltProtocolV57.VERSION.equals(version)) {
            return BoltProtocolV57.INSTANCE;
        }
        String message = "Unknown protocol version: " + version;
        throw new ClientException(GqlStatusError.UNKNOWN.getStatus(), GqlStatusError.UNKNOWN.getStatusDescription(message), "N/A", message, GqlStatusError.DIAGNOSTIC_RECORD, null);
    }
}

