/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.metrics;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntSupplier;
import org.neo4j.driver.ConnectionPoolMetrics;
import org.neo4j.driver.internal.bolt.api.BoltServerAddress;
import org.neo4j.driver.internal.bolt.api.ListenerEvent;
import org.neo4j.driver.internal.metrics.ConnectionPoolMetricsListener;
import org.neo4j.driver.internal.metrics.MicrometerTimerListenerEvent;

final class MicrometerConnectionPoolMetrics
implements ConnectionPoolMetricsListener,
ConnectionPoolMetrics {
    public static final String PREFIX = "neo4j.driver.connections";
    public static final String IN_USE = "neo4j.driver.connections.in.use";
    public static final String IDLE = "neo4j.driver.connections.idle";
    public static final String CREATING = "neo4j.driver.connections.creating";
    public static final String FAILED = "neo4j.driver.connections.failed";
    public static final String CLOSED = "neo4j.driver.connections.closed";
    public static final String ACQUIRING = "neo4j.driver.connections.acquiring";
    public static final String ACQUISITION_TIMEOUT = "neo4j.driver.connections.acquisition.timeout";
    public static final String ACQUISITION = "neo4j.driver.connections.acquisition";
    public static final String CREATION = "neo4j.driver.connections.creation";
    public static final String USAGE = "neo4j.driver.connections.usage";
    private final IntSupplier inUseSupplier;
    private final IntSupplier idleSupplier;
    private final String id;
    private final AtomicInteger creating = new AtomicInteger();
    private final Counter failedToCreate;
    private final Counter closed;
    private final AtomicInteger acquiring = new AtomicInteger();
    private final Counter timedOutToAcquire;
    private final Timer totalAcquisitionTimer;
    private final Timer totalConnectionTimer;
    private final Timer totalInUseTimer;

    MicrometerConnectionPoolMetrics(String poolId, BoltServerAddress address, IntSupplier inUseSupplier, IntSupplier idleSupplier, MeterRegistry registry) {
        this(poolId, address, inUseSupplier, idleSupplier, registry, (Iterable<Tag>)Tags.empty());
    }

    MicrometerConnectionPoolMetrics(String poolId, BoltServerAddress address, IntSupplier inUseSupplier, IntSupplier idleSupplier, MeterRegistry registry, Iterable<Tag> initialTags) {
        Objects.requireNonNull(poolId);
        Objects.requireNonNull(address);
        Objects.requireNonNull(inUseSupplier);
        Objects.requireNonNull(idleSupplier);
        Objects.requireNonNull(registry);
        this.id = poolId;
        this.inUseSupplier = inUseSupplier;
        this.idleSupplier = idleSupplier;
        Tags tags = Tags.concat(initialTags, (String[])new String[]{"address", String.format("%s:%d", address.connectionHost(), address.port())});
        Gauge.builder((String)IN_USE, this::inUse).tags((Iterable)tags).register(registry);
        Gauge.builder((String)IDLE, this::idle).tags((Iterable)tags).register(registry);
        Gauge.builder((String)CREATING, (Object)this.creating, AtomicInteger::get).tags((Iterable)tags).register(registry);
        this.failedToCreate = Counter.builder((String)FAILED).tags((Iterable)tags).register(registry);
        this.closed = Counter.builder((String)CLOSED).tags((Iterable)tags).register(registry);
        Gauge.builder((String)ACQUIRING, (Object)this.acquiring, AtomicInteger::get).tags((Iterable)tags).register(registry);
        this.timedOutToAcquire = Counter.builder((String)ACQUISITION_TIMEOUT).tags((Iterable)tags).register(registry);
        this.totalAcquisitionTimer = Timer.builder((String)ACQUISITION).tags((Iterable)tags).register(registry);
        this.totalConnectionTimer = Timer.builder((String)CREATION).tags((Iterable)tags).register(registry);
        this.totalInUseTimer = Timer.builder((String)USAGE).tags((Iterable)tags).register(registry);
    }

    @Override
    public void beforeCreating(ListenerEvent<?> connEvent) {
        this.creating.incrementAndGet();
        connEvent.start();
    }

    @Override
    public void afterFailedToCreate() {
        this.failedToCreate.increment();
        this.creating.decrementAndGet();
    }

    @Override
    public void afterCreated(ListenerEvent<?> connEvent) {
        this.creating.decrementAndGet();
        Timer.Sample sample = ((MicrometerTimerListenerEvent)connEvent).getSample();
        sample.stop(this.totalConnectionTimer);
    }

    @Override
    public void afterClosed() {
        this.closed.increment();
    }

    @Override
    public void beforeAcquiringOrCreating(ListenerEvent<?> acquireEvent) {
        acquireEvent.start();
        this.acquiring.incrementAndGet();
    }

    @Override
    public void afterAcquiringOrCreating() {
        this.acquiring.decrementAndGet();
    }

    @Override
    public void afterAcquiredOrCreated(ListenerEvent<?> acquireEvent) {
        Timer.Sample sample = ((MicrometerTimerListenerEvent)acquireEvent).getSample();
        sample.stop(this.totalAcquisitionTimer);
    }

    @Override
    public void afterTimedOutToAcquireOrCreate() {
        this.timedOutToAcquire.increment();
    }

    @Override
    public void acquired(ListenerEvent<?> inUseEvent) {
        inUseEvent.start();
    }

    @Override
    public void released(ListenerEvent<?> inUseEvent) {
        Timer.Sample sample = ((MicrometerTimerListenerEvent)inUseEvent).getSample();
        sample.stop(this.totalInUseTimer);
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public int inUse() {
        return this.inUseSupplier.getAsInt();
    }

    @Override
    public int idle() {
        return this.idleSupplier.getAsInt();
    }

    @Override
    public int creating() {
        return this.creating.get();
    }

    @Override
    public long created() {
        return this.totalConnectionTimer.count();
    }

    @Override
    public long failedToCreate() {
        return this.count(this.failedToCreate);
    }

    @Override
    public long closed() {
        return this.count(this.closed);
    }

    @Override
    public int acquiring() {
        return this.acquiring.get();
    }

    @Override
    public long acquired() {
        return this.totalAcquisitionTimer.count();
    }

    @Override
    public long timedOutToAcquire() {
        return this.count(this.timedOutToAcquire);
    }

    @Override
    public long totalAcquisitionTime() {
        return (long)this.totalAcquisitionTimer.totalTime(TimeUnit.MILLISECONDS);
    }

    @Override
    public long totalConnectionTime() {
        return (long)this.totalConnectionTimer.totalTime(TimeUnit.MILLISECONDS);
    }

    @Override
    public long totalInUseTime() {
        return (long)this.totalInUseTimer.totalTime(TimeUnit.MILLISECONDS);
    }

    @Override
    public long totalInUseCount() {
        return this.totalInUseTimer.count();
    }

    public String toString() {
        return String.format("%s=[created=%s, closed=%s, creating=%s, failedToCreate=%s, acquiring=%s, acquired=%s, timedOutToAcquire=%s, inUse=%s, idle=%s, totalAcquisitionTime=%s, totalConnectionTime=%s, totalInUseTime=%s, totalInUseCount=%s]", this.id(), this.created(), this.closed(), this.creating(), this.failedToCreate(), this.acquiring(), this.acquired(), this.timedOutToAcquire(), this.inUse(), this.idle(), this.totalAcquisitionTime(), this.totalConnectionTime(), this.totalInUseTime(), this.totalInUseCount());
    }

    private long count(Counter counter) {
        return (long)counter.count();
    }
}

