/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.bolt.basicimpl.messaging.v4;

import java.time.Clock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.neo4j.driver.Record;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.internal.InternalRecord;
import org.neo4j.driver.internal.bolt.api.AccessMode;
import org.neo4j.driver.internal.bolt.api.BoltProtocolVersion;
import org.neo4j.driver.internal.bolt.api.BoltServerAddress;
import org.neo4j.driver.internal.bolt.api.ClusterComposition;
import org.neo4j.driver.internal.bolt.api.DatabaseName;
import org.neo4j.driver.internal.bolt.api.DatabaseNameUtil;
import org.neo4j.driver.internal.bolt.api.LoggingProvider;
import org.neo4j.driver.internal.bolt.api.NotificationConfig;
import org.neo4j.driver.internal.bolt.api.summary.PullSummary;
import org.neo4j.driver.internal.bolt.api.summary.RouteSummary;
import org.neo4j.driver.internal.bolt.api.summary.RunSummary;
import org.neo4j.driver.internal.bolt.basicimpl.handlers.PullResponseHandlerImpl;
import org.neo4j.driver.internal.bolt.basicimpl.handlers.RunResponseHandler;
import org.neo4j.driver.internal.bolt.basicimpl.messaging.BoltProtocol;
import org.neo4j.driver.internal.bolt.basicimpl.messaging.MessageFormat;
import org.neo4j.driver.internal.bolt.basicimpl.messaging.MessageHandler;
import org.neo4j.driver.internal.bolt.basicimpl.messaging.PullMessageHandler;
import org.neo4j.driver.internal.bolt.basicimpl.messaging.request.PullMessage;
import org.neo4j.driver.internal.bolt.basicimpl.messaging.request.RunWithMetadataMessage;
import org.neo4j.driver.internal.bolt.basicimpl.messaging.v3.BoltProtocolV3;
import org.neo4j.driver.internal.bolt.basicimpl.messaging.v4.MessageFormatV4;
import org.neo4j.driver.internal.bolt.basicimpl.spi.Connection;
import org.neo4j.driver.types.MapAccessor;

public class BoltProtocolV4
extends BoltProtocolV3 {
    public static final BoltProtocolVersion VERSION = new BoltProtocolVersion(4, 0);
    public static final BoltProtocol INSTANCE = new BoltProtocolV4();
    private static final String ROUTING_CONTEXT = "context";
    private static final String DATABASE_NAME = "database";
    private static final String MULTI_DB_GET_ROUTING_TABLE = String.format("CALL dbms.routing.getRoutingTable($%s, $%s)", "context", "database");

    @Override
    public MessageFormat createMessageFormat() {
        return new MessageFormatV4();
    }

    @Override
    public CompletionStage<Void> route(Connection connection, Map<String, Value> routingContext, Set<String> bookmarks, String databaseName, String impersonatedUser, MessageHandler<RouteSummary> handler, Clock clock, LoggingProvider logging) {
        HashMap<String, Value> parameters = new HashMap<String, Value>();
        parameters.put(ROUTING_CONTEXT, Values.value(routingContext));
        parameters.put(DATABASE_NAME, Values.value((Object)databaseName));
        BoltProtocolV3.Query query = new BoltProtocolV3.Query(MULTI_DB_GET_ROUTING_TABLE, parameters);
        RunWithMetadataMessage runMessage = RunWithMetadataMessage.autoCommitTxRunMessage(query.query(), query.parameters(), null, Collections.emptyMap(), DatabaseNameUtil.database("system"), AccessMode.READ, bookmarks, null, NotificationConfig.defaultConfig(), this.useLegacyNotifications(), logging);
        final CompletableFuture<RunSummary> runFuture = new CompletableFuture<RunSummary>();
        RunResponseHandler runHandler = new RunResponseHandler(runFuture, METADATA_EXTRACTOR);
        final CompletableFuture pullFuture = new CompletableFuture();
        final ArrayList records = new ArrayList();
        ((CompletableFuture)((CompletableFuture)runFuture.thenCompose(ignored -> pullFuture)).thenApply(ignored -> {
            Record map = (Record)records.get(0);
            long ttl = map.get("ttl").asLong();
            long expirationTimestamp = clock.millis() + ttl * 1000L;
            if (ttl < 0L || ttl >= 9223372036854775L || expirationTimestamp < 0L) {
                expirationTimestamp = Long.MAX_VALUE;
            }
            LinkedHashSet<BoltServerAddress> readers = new LinkedHashSet<BoltServerAddress>();
            LinkedHashSet<BoltServerAddress> writers = new LinkedHashSet<BoltServerAddress>();
            LinkedHashSet<BoltServerAddress> routers = new LinkedHashSet<BoltServerAddress>();
            for (Map serversMap : map.get("servers").asList(MapAccessor::asMap)) {
                String role = Values.value(serversMap.get("role")).asString();
                for (Object server : Values.value(serversMap.get("addresses")).asList()) {
                    BoltServerAddress address = new BoltServerAddress(Values.value(server).asString());
                    switch (role) {
                        case "WRITE": {
                            writers.add(address);
                            break;
                        }
                        case "READ": {
                            readers.add(address);
                            break;
                        }
                        case "ROUTE": {
                            routers.add(address);
                        }
                    }
                }
            }
            Value db = map.get("db");
            String name = db != null ? (String)db.computeOrDefault(Value::asString, null) : null;
            ClusterComposition clusterComposition = new ClusterComposition(expirationTimestamp, readers, writers, routers, name);
            return new RouteSummaryImpl(clusterComposition);
        })).whenComplete((summary, throwable) -> {
            if (throwable != null) {
                handler.onError((Throwable)throwable);
            } else {
                handler.onSummary((RouteSummary)summary);
            }
        });
        return connection.write(runMessage, runHandler).thenCompose(ignored -> {
            PullMessage pullMessage = new PullMessage(-1L, -1L);
            PullResponseHandlerImpl pullHandler = new PullResponseHandlerImpl(new PullMessageHandler(){

                @Override
                public void onRecord(Value[] fields) {
                    List<String> keys = ((RunSummary)runFuture.join()).keys();
                    records.add(new InternalRecord(keys, fields));
                }

                @Override
                public void onError(Throwable throwable) {
                    pullFuture.completeExceptionally(throwable);
                }

                @Override
                public void onSummary(PullSummary success) {
                    pullFuture.complete(success);
                }
            });
            return connection.write(pullMessage, pullHandler);
        });
    }

    @Override
    public CompletionStage<Void> pull(Connection connection, long qid, long request, PullMessageHandler handler) {
        PullMessage pullMessage = new PullMessage(request, qid);
        CompletableFuture pullFuture = new CompletableFuture();
        PullResponseHandlerImpl pullHandler = new PullResponseHandlerImpl(handler);
        return connection.write(pullMessage, pullHandler);
    }

    @Override
    protected void verifyDatabaseNameBeforeTransaction(DatabaseName databaseName) {
    }

    @Override
    public BoltProtocolVersion version() {
        return VERSION;
    }

    private record RouteSummaryImpl(ClusterComposition clusterComposition) implements RouteSummary
    {
    }
}

