/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cursor;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.neo4j.driver.internal.cursor.AsyncResultCursor;
import org.neo4j.driver.internal.cursor.AsyncResultCursorImpl;
import org.neo4j.driver.internal.cursor.DisposableAsyncResultCursor;
import org.neo4j.driver.internal.cursor.ResultCursorFactory;
import org.neo4j.driver.internal.cursor.RxResultCursor;
import org.neo4j.driver.internal.cursor.RxResultCursorImpl;
import org.neo4j.driver.internal.handlers.PullAllResponseHandler;
import org.neo4j.driver.internal.handlers.RunResponseHandler;
import org.neo4j.driver.internal.handlers.pulln.PullResponseHandler;
import org.neo4j.driver.internal.messaging.Message;
import org.neo4j.driver.internal.spi.Connection;

public class ResultCursorFactoryImpl
implements ResultCursorFactory {
    private final RunResponseHandler runHandler;
    private final Connection connection;
    private final PullResponseHandler pullHandler;
    private final PullAllResponseHandler pullAllHandler;
    private final Message runMessage;
    private final CompletableFuture<Void> runFuture;

    public ResultCursorFactoryImpl(Connection connection, Message runMessage, RunResponseHandler runHandler, CompletableFuture<Void> runFuture, PullResponseHandler pullHandler, PullAllResponseHandler pullAllHandler) {
        Objects.requireNonNull(connection);
        Objects.requireNonNull(runMessage);
        Objects.requireNonNull(runHandler);
        Objects.requireNonNull(runFuture);
        Objects.requireNonNull(pullHandler);
        Objects.requireNonNull(pullAllHandler);
        this.connection = connection;
        this.runMessage = runMessage;
        this.runHandler = runHandler;
        this.runFuture = runFuture;
        this.pullHandler = pullHandler;
        this.pullAllHandler = pullAllHandler;
    }

    @Override
    public CompletionStage<AsyncResultCursor> asyncResult() {
        this.connection.write(this.runMessage, this.runHandler);
        this.pullAllHandler.prePopulateRecords();
        return this.runFuture.handle((ignored, error) -> new DisposableAsyncResultCursor(new AsyncResultCursorImpl((Throwable)error, this.runHandler, this.pullAllHandler)));
    }

    @Override
    public CompletionStage<RxResultCursor> rxResult() {
        this.connection.writeAndFlush(this.runMessage, this.runHandler);
        return this.runFuture.handle((ignored, error) -> new RxResultCursorImpl((Throwable)error, this.runHandler, this.pullHandler, this.connection::release));
    }
}

