/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.security;

import java.io.IOException;
import java.security.GeneralSecurityException;
import org.neo4j.driver.Config;
import org.neo4j.driver.RevocationCheckingStrategy;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.internal.Scheme;
import org.neo4j.driver.internal.SecuritySettings;
import org.neo4j.driver.internal.security.SecurityPlan;
import org.neo4j.driver.internal.security.SecurityPlanImpl;

public class SecurityPlans {
    public static SecurityPlan createSecurityPlan(SecuritySettings settings, String uriScheme) {
        Scheme.validateScheme(uriScheme);
        try {
            if (Scheme.isSecurityScheme(uriScheme)) {
                SecurityPlans.assertSecuritySettingsNotUserConfigured(settings, uriScheme);
                return SecurityPlans.createSecurityPlanFromScheme(uriScheme);
            }
            return SecurityPlans.createSecurityPlanImpl(settings.encrypted(), settings.trustStrategy());
        }
        catch (IOException | GeneralSecurityException ex) {
            throw new ClientException("Unable to establish SSL parameters", ex);
        }
    }

    private static void assertSecuritySettingsNotUserConfigured(SecuritySettings settings, String uriScheme) {
        if (SecurityPlans.isCustomized(settings)) {
            throw new ClientException(String.format("Scheme %s is not configurable with manual encryption and trust settings", uriScheme));
        }
    }

    public static boolean isCustomized(SecuritySettings securitySettings) {
        return SecuritySettings.DEFAULT.encrypted() != securitySettings.encrypted() || !SecurityPlans.hasEqualTrustStrategy(securitySettings);
    }

    private static boolean hasEqualTrustStrategy(SecuritySettings settings) {
        Config.TrustStrategy t2;
        Config.TrustStrategy t1 = SecuritySettings.DEFAULT.trustStrategy();
        if (t1 == (t2 = settings.trustStrategy())) {
            return true;
        }
        return t1.isHostnameVerificationEnabled() == t2.isHostnameVerificationEnabled() && t1.strategy() == t2.strategy() && t1.certFiles().equals(t2.certFiles()) && t1.revocationCheckingStrategy() == t2.revocationCheckingStrategy();
    }

    private static SecurityPlan createSecurityPlanFromScheme(String scheme) throws GeneralSecurityException, IOException {
        if (Scheme.isHighTrustScheme(scheme)) {
            return SecurityPlanImpl.forSystemCASignedCertificates(true, RevocationCheckingStrategy.NO_CHECKS);
        }
        return SecurityPlanImpl.forAllCertificates(false, RevocationCheckingStrategy.NO_CHECKS);
    }

    private static SecurityPlan createSecurityPlanImpl(boolean encrypted, Config.TrustStrategy trustStrategy) throws GeneralSecurityException, IOException {
        if (encrypted) {
            boolean hostnameVerificationEnabled = trustStrategy.isHostnameVerificationEnabled();
            RevocationCheckingStrategy revocationCheckingStrategy = trustStrategy.revocationCheckingStrategy();
            return switch (trustStrategy.strategy()) {
                default -> throw new IncompatibleClassChangeError();
                case Config.TrustStrategy.Strategy.TRUST_CUSTOM_CA_SIGNED_CERTIFICATES -> SecurityPlanImpl.forCustomCASignedCertificates(trustStrategy.certFiles(), hostnameVerificationEnabled, revocationCheckingStrategy);
                case Config.TrustStrategy.Strategy.TRUST_SYSTEM_CA_SIGNED_CERTIFICATES -> SecurityPlanImpl.forSystemCASignedCertificates(hostnameVerificationEnabled, revocationCheckingStrategy);
                case Config.TrustStrategy.Strategy.TRUST_ALL_CERTIFICATES -> SecurityPlanImpl.forAllCertificates(hostnameVerificationEnabled, revocationCheckingStrategy);
            };
        }
        return SecurityPlanImpl.insecure();
    }
}

