/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.time.Duration;
import java.time.Period;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.util.List;
import java.util.Objects;
import org.neo4j.driver.types.IsoDuration;

public class InternalIsoDuration
implements IsoDuration {
    private static final long NANOS_PER_SECOND = 1000000000L;
    private static final List<TemporalUnit> SUPPORTED_UNITS = List.of(ChronoUnit.MONTHS, ChronoUnit.DAYS, ChronoUnit.SECONDS, ChronoUnit.NANOS);
    private final long months;
    private final long days;
    private final long seconds;
    private final int nanoseconds;

    public InternalIsoDuration(Period period) {
        this(period.toTotalMonths(), period.getDays(), Duration.ZERO);
    }

    public InternalIsoDuration(Duration duration) {
        this(0L, 0L, duration);
    }

    public InternalIsoDuration(long months, long days, long seconds, int nanoseconds) {
        this(months, days, Duration.ofSeconds(seconds, nanoseconds));
    }

    InternalIsoDuration(long months, long days, Duration duration) {
        this.months = months;
        this.days = days;
        this.seconds = duration.getSeconds();
        this.nanoseconds = duration.getNano();
    }

    @Override
    public long months() {
        return this.months;
    }

    @Override
    public long days() {
        return this.days;
    }

    @Override
    public long seconds() {
        return this.seconds;
    }

    @Override
    public int nanoseconds() {
        return this.nanoseconds;
    }

    @Override
    public long get(TemporalUnit unit) {
        if (unit == ChronoUnit.MONTHS) {
            return this.months;
        }
        if (unit == ChronoUnit.DAYS) {
            return this.days;
        }
        if (unit == ChronoUnit.SECONDS) {
            return this.seconds;
        }
        if (unit == ChronoUnit.NANOS) {
            return this.nanoseconds;
        }
        throw new UnsupportedTemporalTypeException("Unsupported unit: " + unit);
    }

    @Override
    public List<TemporalUnit> getUnits() {
        return SUPPORTED_UNITS;
    }

    @Override
    public Temporal addTo(Temporal temporal) {
        if (this.months != 0L) {
            temporal = temporal.plus(this.months, ChronoUnit.MONTHS);
        }
        if (this.days != 0L) {
            temporal = temporal.plus(this.days, ChronoUnit.DAYS);
        }
        if (this.seconds != 0L) {
            temporal = temporal.plus(this.seconds, ChronoUnit.SECONDS);
        }
        if (this.nanoseconds != 0) {
            temporal = temporal.plus(this.nanoseconds, ChronoUnit.NANOS);
        }
        return temporal;
    }

    @Override
    public Temporal subtractFrom(Temporal temporal) {
        if (this.months != 0L) {
            temporal = temporal.minus(this.months, ChronoUnit.MONTHS);
        }
        if (this.days != 0L) {
            temporal = temporal.minus(this.days, ChronoUnit.DAYS);
        }
        if (this.seconds != 0L) {
            temporal = temporal.minus(this.seconds, ChronoUnit.SECONDS);
        }
        if (this.nanoseconds != 0) {
            temporal = temporal.minus(this.nanoseconds, ChronoUnit.NANOS);
        }
        return temporal;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InternalIsoDuration that = (InternalIsoDuration)o;
        return this.months == that.months && this.days == that.days && this.seconds == that.seconds && this.nanoseconds == that.nanoseconds;
    }

    public int hashCode() {
        return Objects.hash(this.months, this.days, this.seconds, this.nanoseconds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('P');
        sb.append(this.months).append('M');
        sb.append(this.days).append('D');
        sb.append('T');
        if (this.seconds < 0L && this.nanoseconds > 0) {
            if (this.seconds == -1L) {
                sb.append("-0");
            } else {
                sb.append(this.seconds + 1L);
            }
        } else {
            sb.append(this.seconds);
        }
        if (this.nanoseconds > 0) {
            int pos = sb.length();
            if (this.seconds < 0L) {
                sb.append(2000000000L - (long)this.nanoseconds);
            } else {
                sb.append(1000000000L + (long)this.nanoseconds);
            }
            sb.setCharAt(pos, '.');
        }
        sb.append('S');
        return sb.toString();
    }
}

