/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver;

import java.time.Clock;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.neo4j.driver.AuthTokenAndExpiration;
import org.neo4j.driver.AuthTokenManager;
import org.neo4j.driver.internal.security.ExpirationBasedAuthTokenManager;
import org.neo4j.driver.util.Preview;

@Preview(name="AuthToken rotation and session auth support")
public final class AuthTokenManagers {
    private AuthTokenManagers() {
    }

    public static AuthTokenManager expirationBased(Supplier<AuthTokenAndExpiration> newTokenSupplier) {
        return AuthTokenManagers.expirationBasedAsync(() -> CompletableFuture.supplyAsync(newTokenSupplier));
    }

    public static AuthTokenManager expirationBasedAsync(Supplier<CompletionStage<AuthTokenAndExpiration>> newTokenStageSupplier) {
        return new ExpirationBasedAuthTokenManager(newTokenStageSupplier, Clock.systemUTC());
    }
}

