/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.handlers;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.DatabaseBookmark;
import org.neo4j.driver.internal.spi.ResponseHandler;
import org.neo4j.driver.internal.util.MetadataExtractor;

public class CommitTxResponseHandler
implements ResponseHandler {
    private final CompletableFuture<DatabaseBookmark> commitFuture;

    public CommitTxResponseHandler(CompletableFuture<DatabaseBookmark> commitFuture) {
        this.commitFuture = Objects.requireNonNull(commitFuture);
    }

    @Override
    public void onSuccess(Map<String, Value> metadata) {
        this.commitFuture.complete(MetadataExtractor.extractDatabaseBookmark(metadata));
    }

    @Override
    public void onFailure(Throwable error) {
        this.commitFuture.completeExceptionally(error);
    }

    @Override
    public void onRecord(Value[] fields) {
        throw new UnsupportedOperationException("Transaction commit is not expected to receive records: " + Arrays.toString(fields));
    }
}

