/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.util;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Query;
import org.neo4j.driver.Value;
import org.neo4j.driver.exceptions.ProtocolException;
import org.neo4j.driver.exceptions.UntrustedServerException;
import org.neo4j.driver.internal.InternalBookmark;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.summary.InternalDatabaseInfo;
import org.neo4j.driver.internal.summary.InternalNotification;
import org.neo4j.driver.internal.summary.InternalPlan;
import org.neo4j.driver.internal.summary.InternalProfiledPlan;
import org.neo4j.driver.internal.summary.InternalResultSummary;
import org.neo4j.driver.internal.summary.InternalServerInfo;
import org.neo4j.driver.internal.summary.InternalSummaryCounters;
import org.neo4j.driver.internal.types.InternalTypeSystem;
import org.neo4j.driver.internal.util.QueryKeys;
import org.neo4j.driver.summary.DatabaseInfo;
import org.neo4j.driver.summary.Notification;
import org.neo4j.driver.summary.Plan;
import org.neo4j.driver.summary.ProfiledPlan;
import org.neo4j.driver.summary.QueryType;
import org.neo4j.driver.summary.ResultSummary;

public class MetadataExtractor {
    public static final int ABSENT_QUERY_ID = -1;
    private static final String UNEXPECTED_TYPE_MSG_FMT = "Unexpected query type '%s', consider updating the driver";
    private static final Function<String, ProtocolException> UNEXPECTED_TYPE_EXCEPTION_SUPPLIER = type -> new ProtocolException(String.format(UNEXPECTED_TYPE_MSG_FMT, type));
    private final String resultAvailableAfterMetadataKey;
    private final String resultConsumedAfterMetadataKey;

    public MetadataExtractor(String resultAvailableAfterMetadataKey, String resultConsumedAfterMetadataKey) {
        this.resultAvailableAfterMetadataKey = resultAvailableAfterMetadataKey;
        this.resultConsumedAfterMetadataKey = resultConsumedAfterMetadataKey;
    }

    public QueryKeys extractQueryKeys(Map<String, Value> metadata) {
        Value keysValue = metadata.get("fields");
        if (keysValue != null && !keysValue.isEmpty()) {
            QueryKeys keys = new QueryKeys(keysValue.size());
            for (Value value : keysValue.values()) {
                keys.add(value.asString());
            }
            return keys;
        }
        return QueryKeys.empty();
    }

    public long extractQueryId(Map<String, Value> metadata) {
        Value queryId = metadata.get("qid");
        if (queryId != null) {
            return queryId.asLong();
        }
        return -1L;
    }

    public long extractResultAvailableAfter(Map<String, Value> metadata) {
        Value resultAvailableAfterValue = metadata.get(this.resultAvailableAfterMetadataKey);
        if (resultAvailableAfterValue != null) {
            return resultAvailableAfterValue.asLong();
        }
        return -1L;
    }

    public ResultSummary extractSummary(Query query, Connection connection, long resultAvailableAfter, Map<String, Value> metadata) {
        InternalServerInfo serverInfo = new InternalServerInfo(connection.serverAgent(), connection.serverAddress(), connection.protocol().version());
        DatabaseInfo dbInfo = MetadataExtractor.extractDatabaseInfo(metadata);
        return new InternalResultSummary(query, serverInfo, dbInfo, MetadataExtractor.extractQueryType(metadata), MetadataExtractor.extractCounters(metadata), MetadataExtractor.extractPlan(metadata), MetadataExtractor.extractProfiledPlan(metadata), MetadataExtractor.extractNotifications(metadata), resultAvailableAfter, MetadataExtractor.extractResultConsumedAfter(metadata, this.resultConsumedAfterMetadataKey));
    }

    public static DatabaseInfo extractDatabaseInfo(Map<String, Value> metadata) {
        Value dbValue = metadata.get("db");
        if (dbValue == null || dbValue.isNull()) {
            return InternalDatabaseInfo.DEFAULT_DATABASE_INFO;
        }
        return new InternalDatabaseInfo(dbValue.asString());
    }

    public static Bookmark extractBookmarks(Map<String, Value> metadata) {
        Value bookmarkValue = metadata.get("bookmark");
        return bookmarkValue != null && !bookmarkValue.isNull() && bookmarkValue.hasType(InternalTypeSystem.TYPE_SYSTEM.STRING()) ? InternalBookmark.parse(bookmarkValue.asString()) : InternalBookmark.empty();
    }

    public static Value extractServer(Map<String, Value> metadata) {
        Value versionValue = metadata.get("server");
        if (versionValue == null || versionValue.isNull()) {
            throw new UntrustedServerException("Server provides no product identifier");
        }
        String serverAgent = versionValue.asString();
        if (!serverAgent.startsWith("Neo4j/")) {
            throw new UntrustedServerException("Server does not identify as a genuine Neo4j instance: '" + serverAgent + "'");
        }
        return versionValue;
    }

    private static QueryType extractQueryType(Map<String, Value> metadata) {
        Value typeValue = metadata.get("type");
        if (typeValue != null) {
            return QueryType.fromCode(typeValue.asString(), UNEXPECTED_TYPE_EXCEPTION_SUPPLIER);
        }
        return null;
    }

    private static InternalSummaryCounters extractCounters(Map<String, Value> metadata) {
        Value countersValue = metadata.get("stats");
        if (countersValue != null) {
            return new InternalSummaryCounters(MetadataExtractor.counterValue(countersValue, "nodes-created"), MetadataExtractor.counterValue(countersValue, "nodes-deleted"), MetadataExtractor.counterValue(countersValue, "relationships-created"), MetadataExtractor.counterValue(countersValue, "relationships-deleted"), MetadataExtractor.counterValue(countersValue, "properties-set"), MetadataExtractor.counterValue(countersValue, "labels-added"), MetadataExtractor.counterValue(countersValue, "labels-removed"), MetadataExtractor.counterValue(countersValue, "indexes-added"), MetadataExtractor.counterValue(countersValue, "indexes-removed"), MetadataExtractor.counterValue(countersValue, "constraints-added"), MetadataExtractor.counterValue(countersValue, "constraints-removed"), MetadataExtractor.counterValue(countersValue, "system-updates"));
        }
        return null;
    }

    private static int counterValue(Value countersValue, String name) {
        Value value = countersValue.get(name);
        return value.isNull() ? 0 : value.asInt();
    }

    private static Plan extractPlan(Map<String, Value> metadata) {
        Value planValue = metadata.get("plan");
        if (planValue != null) {
            return InternalPlan.EXPLAIN_PLAN_FROM_VALUE.apply(planValue);
        }
        return null;
    }

    private static ProfiledPlan extractProfiledPlan(Map<String, Value> metadata) {
        Value profiledPlanValue = metadata.get("profile");
        if (profiledPlanValue != null) {
            return InternalProfiledPlan.PROFILED_PLAN_FROM_VALUE.apply(profiledPlanValue);
        }
        return null;
    }

    private static List<Notification> extractNotifications(Map<String, Value> metadata) {
        Value notificationsValue = metadata.get("notifications");
        if (notificationsValue != null) {
            return notificationsValue.asList(InternalNotification.VALUE_TO_NOTIFICATION);
        }
        return Collections.emptyList();
    }

    private static long extractResultConsumedAfter(Map<String, Value> metadata, String key) {
        Value resultConsumedAfterValue = metadata.get(key);
        if (resultConsumedAfterValue != null) {
            return resultConsumedAfterValue.asLong();
        }
        return -1L;
    }
}

