/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async.outbound;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.EncoderException;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.util.List;
import org.neo4j.driver.Logger;
import org.neo4j.driver.Logging;
import org.neo4j.driver.internal.async.connection.BoltProtocolUtil;
import org.neo4j.driver.internal.async.outbound.ChunkAwareByteBufOutput;
import org.neo4j.driver.internal.logging.ChannelActivityLogger;
import org.neo4j.driver.internal.messaging.Message;
import org.neo4j.driver.internal.messaging.MessageFormat;

public class OutboundMessageHandler
extends MessageToMessageEncoder<Message> {
    public static final String NAME = OutboundMessageHandler.class.getSimpleName();
    private final ChunkAwareByteBufOutput output = new ChunkAwareByteBufOutput();
    private final MessageFormat.Writer writer;
    private final Logging logging;
    private Logger log;

    public OutboundMessageHandler(MessageFormat messageFormat, Logging logging) {
        this.writer = messageFormat.newWriter(this.output);
        this.logging = logging;
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        this.log = new ChannelActivityLogger(ctx.channel(), this.logging, ((Object)((Object)this)).getClass());
    }

    public void handlerRemoved(ChannelHandlerContext ctx) {
        this.log = null;
    }

    protected void encode(ChannelHandlerContext ctx, Message msg, List<Object> out) {
        this.log.debug("C: %s", msg);
        ByteBuf messageBuf = ctx.alloc().ioBuffer();
        this.output.start(messageBuf);
        try {
            this.writer.write(msg);
            this.output.stop();
        }
        catch (Throwable error) {
            this.output.stop();
            messageBuf.release();
            throw new EncoderException("Failed to write outbound message: " + msg, error);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("C: %s", ByteBufUtil.hexDump((ByteBuf)messageBuf));
        }
        BoltProtocolUtil.writeMessageBoundary(messageBuf);
        out.add(messageBuf);
    }
}

