/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cluster;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.neo4j.driver.Logger;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.DatabaseName;
import org.neo4j.driver.internal.async.ConnectionContext;
import org.neo4j.driver.internal.cluster.ClusterCompositionLookupResult;
import org.neo4j.driver.internal.cluster.Rediscovery;
import org.neo4j.driver.internal.cluster.RoutingTable;
import org.neo4j.driver.internal.cluster.RoutingTableHandler;
import org.neo4j.driver.internal.cluster.RoutingTableRegistry;
import org.neo4j.driver.internal.spi.ConnectionPool;
import org.neo4j.driver.internal.util.Futures;

public class RoutingTableHandlerImpl
implements RoutingTableHandler {
    private final RoutingTable routingTable;
    private final DatabaseName databaseName;
    private final RoutingTableRegistry routingTableRegistry;
    private volatile CompletableFuture<RoutingTable> refreshRoutingTableFuture;
    private final ConnectionPool connectionPool;
    private final Rediscovery rediscovery;
    private final Logger log;
    private final long routingTablePurgeDelayMs;
    private final Set<BoltServerAddress> resolvedInitialRouters = new HashSet<BoltServerAddress>();

    public RoutingTableHandlerImpl(RoutingTable routingTable, Rediscovery rediscovery, ConnectionPool connectionPool, RoutingTableRegistry routingTableRegistry, Logger log, long routingTablePurgeDelayMs) {
        this.routingTable = routingTable;
        this.databaseName = routingTable.database();
        this.rediscovery = rediscovery;
        this.connectionPool = connectionPool;
        this.routingTableRegistry = routingTableRegistry;
        this.log = log;
        this.routingTablePurgeDelayMs = routingTablePurgeDelayMs;
    }

    @Override
    public void onConnectionFailure(BoltServerAddress address) {
        this.routingTable.forget(address);
    }

    @Override
    public void onWriteFailure(BoltServerAddress address) {
        this.routingTable.forgetWriter(address);
    }

    @Override
    public synchronized CompletionStage<RoutingTable> ensureRoutingTable(ConnectionContext context) {
        if (this.refreshRoutingTableFuture != null) {
            return this.refreshRoutingTableFuture;
        }
        if (this.routingTable.isStaleFor(context.mode())) {
            this.log.debug("Routing table for database '%s' is stale. %s", this.databaseName.description(), this.routingTable);
            CompletableFuture<RoutingTable> resultFuture = new CompletableFuture<RoutingTable>();
            this.refreshRoutingTableFuture = resultFuture;
            this.rediscovery.lookupClusterComposition(this.routingTable, this.connectionPool, context.rediscoveryBookmark()).whenComplete((composition, completionError) -> {
                Throwable error = Futures.completionExceptionCause(completionError);
                if (error != null) {
                    this.clusterCompositionLookupFailed(error);
                } else {
                    this.freshClusterCompositionFetched((ClusterCompositionLookupResult)composition);
                }
            });
            return resultFuture;
        }
        return CompletableFuture.completedFuture(this.routingTable);
    }

    private synchronized void freshClusterCompositionFetched(ClusterCompositionLookupResult compositionLookupResult) {
        try {
            this.log.debug("Fetched cluster composition for database '%s'. %s", this.databaseName.description(), compositionLookupResult.getClusterComposition());
            this.routingTable.update(compositionLookupResult.getClusterComposition());
            this.routingTableRegistry.removeAged();
            LinkedHashSet<BoltServerAddress> addressesToRetain = new LinkedHashSet<BoltServerAddress>();
            this.routingTableRegistry.allServers().stream().flatMap(BoltServerAddress::unicastStream).forEach(addressesToRetain::add);
            compositionLookupResult.getResolvedInitialRouters().ifPresent(addresses -> {
                this.resolvedInitialRouters.clear();
                this.resolvedInitialRouters.addAll((Collection<BoltServerAddress>)addresses);
            });
            addressesToRetain.addAll(this.resolvedInitialRouters);
            this.connectionPool.retainAll(addressesToRetain);
            this.log.debug("Updated routing table for database '%s'. %s", this.databaseName.description(), this.routingTable);
            CompletableFuture<RoutingTable> routingTableFuture = this.refreshRoutingTableFuture;
            this.refreshRoutingTableFuture = null;
            routingTableFuture.complete(this.routingTable);
        }
        catch (Throwable error) {
            this.clusterCompositionLookupFailed(error);
        }
    }

    private synchronized void clusterCompositionLookupFailed(Throwable error) {
        this.log.error(String.format("Failed to update routing table for database '%s'. Current routing table: %s.", this.databaseName.description(), this.routingTable), error);
        this.routingTableRegistry.remove(this.databaseName);
        CompletableFuture<RoutingTable> routingTableFuture = this.refreshRoutingTableFuture;
        this.refreshRoutingTableFuture = null;
        routingTableFuture.completeExceptionally(error);
    }

    @Override
    public Set<BoltServerAddress> servers() {
        return this.routingTable.servers();
    }

    @Override
    public boolean isRoutingTableAged() {
        return this.refreshRoutingTableFuture == null && this.routingTable.hasBeenStaleFor(this.routingTablePurgeDelayMs);
    }

    @Override
    public RoutingTable routingTable() {
        return this.routingTable;
    }
}

