/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.reactor.util.concurrent;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.LongSupplier;

@Deprecated
public abstract class WaitStrategy {
    public static WaitStrategy blocking() {
        return new Blocking();
    }

    public static WaitStrategy busySpin() {
        return BusySpin.INSTANCE;
    }

    public static boolean isAlert(Throwable t) {
        return t == AlertException.INSTANCE;
    }

    public static WaitStrategy liteBlocking() {
        return new LiteBlocking();
    }

    public static WaitStrategy parking() {
        return Parking.INSTANCE;
    }

    public static WaitStrategy parking(int retries) {
        return new Parking(retries);
    }

    public static WaitStrategy phasedOff(long spinTimeout, long yieldTimeout, TimeUnit units, WaitStrategy delegate) {
        return new PhasedOff(spinTimeout, yieldTimeout, units, delegate);
    }

    public static WaitStrategy phasedOffLiteLock(long spinTimeout, long yieldTimeout, TimeUnit units) {
        return WaitStrategy.phasedOff(spinTimeout, yieldTimeout, units, WaitStrategy.liteBlocking());
    }

    public static WaitStrategy phasedOffLock(long spinTimeout, long yieldTimeout, TimeUnit units) {
        return WaitStrategy.phasedOff(spinTimeout, yieldTimeout, units, WaitStrategy.blocking());
    }

    public static WaitStrategy phasedOffSleep(long spinTimeout, long yieldTimeout, TimeUnit units) {
        return WaitStrategy.phasedOff(spinTimeout, yieldTimeout, units, WaitStrategy.parking(0));
    }

    public static WaitStrategy sleeping() {
        return Sleeping.INSTANCE;
    }

    public static WaitStrategy yielding() {
        return Yielding.INSTANCE;
    }

    public void signalAllWhenBlocking() {
    }

    public abstract long waitFor(long var1, LongSupplier var3, Runnable var4) throws InterruptedException;

    public static void alert() {
        throw AlertException.INSTANCE;
    }

    static final class Yielding
    extends WaitStrategy {
        static final Yielding INSTANCE = new Yielding();
        private static final int SPIN_TRIES = 100;

        Yielding() {
        }

        @Override
        public long waitFor(long sequence, LongSupplier cursor, Runnable barrier) throws InterruptedException {
            long availableSequence;
            int counter = 100;
            while ((availableSequence = cursor.getAsLong()) < sequence) {
                counter = this.applyWaitMethod(barrier, counter);
            }
            return availableSequence;
        }

        private int applyWaitMethod(Runnable barrier, int counter) throws AlertException {
            barrier.run();
            if (0 == counter) {
                Thread.yield();
            } else {
                --counter;
            }
            return counter;
        }
    }

    static final class Parking
    extends WaitStrategy {
        static final Parking INSTANCE = new Parking();
        private final int retries;
        private static final int DEFAULT_RETRIES = 200;

        Parking() {
            this(200);
        }

        Parking(int retries) {
            this.retries = retries;
        }

        @Override
        public long waitFor(long sequence, LongSupplier cursor, Runnable barrier) throws InterruptedException {
            long availableSequence;
            int counter = this.retries;
            while ((availableSequence = cursor.getAsLong()) < sequence) {
                counter = this.applyWaitMethod(barrier, counter);
            }
            return availableSequence;
        }

        private int applyWaitMethod(Runnable barrier, int counter) throws AlertException {
            barrier.run();
            if (counter > 100) {
                --counter;
            } else if (counter > 0) {
                --counter;
                Thread.yield();
            } else {
                LockSupport.parkNanos(1L);
            }
            return counter;
        }
    }

    static final class PhasedOff
    extends WaitStrategy {
        private final long spinTimeoutNanos;
        private final long yieldTimeoutNanos;
        private final WaitStrategy fallbackStrategy;
        private static final int SPIN_TRIES = 10000;

        PhasedOff(long spinTimeout, long yieldTimeout, TimeUnit units, WaitStrategy fallbackStrategy) {
            this.spinTimeoutNanos = units.toNanos(spinTimeout);
            this.yieldTimeoutNanos = this.spinTimeoutNanos + units.toNanos(yieldTimeout);
            this.fallbackStrategy = fallbackStrategy;
        }

        @Override
        public void signalAllWhenBlocking() {
            this.fallbackStrategy.signalAllWhenBlocking();
        }

        @Override
        public long waitFor(long sequence, LongSupplier cursor, Runnable barrier) throws InterruptedException {
            long startTime = 0L;
            int counter = 10000;
            long availableSequence;
            while ((availableSequence = cursor.getAsLong()) < sequence) {
                if (0 == --counter) {
                    if (0L == startTime) {
                        startTime = System.nanoTime();
                    } else {
                        long timeDelta = System.nanoTime() - startTime;
                        if (timeDelta > this.yieldTimeoutNanos) {
                            return this.fallbackStrategy.waitFor(sequence, cursor, barrier);
                        }
                        if (timeDelta > this.spinTimeoutNanos) {
                            Thread.yield();
                        }
                    }
                    counter = 10000;
                }
                barrier.run();
            }
            return availableSequence;
        }
    }

    static final class LiteBlocking
    extends WaitStrategy {
        private final Lock lock = new ReentrantLock();
        private final Condition processorNotifyCondition = this.lock.newCondition();
        private final AtomicBoolean signalNeeded = new AtomicBoolean(false);

        LiteBlocking() {
        }

        @Override
        public void signalAllWhenBlocking() {
            if (this.signalNeeded.getAndSet(false)) {
                this.lock.lock();
                try {
                    this.processorNotifyCondition.signalAll();
                }
                finally {
                    this.lock.unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long waitFor(long sequence, LongSupplier cursorSequence, Runnable barrier) throws InterruptedException {
            long availableSequence = cursorSequence.getAsLong();
            if (availableSequence < sequence) {
                this.lock.lock();
                try {
                    do {
                        this.signalNeeded.getAndSet(true);
                        availableSequence = cursorSequence.getAsLong();
                        if (availableSequence >= sequence) {
                            break;
                        }
                        barrier.run();
                        this.processorNotifyCondition.await();
                    } while ((availableSequence = cursorSequence.getAsLong()) < sequence);
                }
                finally {
                    this.lock.unlock();
                }
            }
            while ((availableSequence = cursorSequence.getAsLong()) < sequence) {
                barrier.run();
            }
            return availableSequence;
        }
    }

    static final class Sleeping
    extends WaitStrategy {
        static final Sleeping INSTANCE = new Sleeping();

        Sleeping() {
        }

        @Override
        public long waitFor(long sequence, LongSupplier cursor, Runnable barrier) throws InterruptedException {
            long availableSequence;
            while ((availableSequence = cursor.getAsLong()) < sequence) {
                barrier.run();
                Thread.sleep(1L);
            }
            return availableSequence;
        }
    }

    static final class BusySpin
    extends WaitStrategy {
        static final BusySpin INSTANCE = new BusySpin();

        BusySpin() {
        }

        @Override
        public long waitFor(long sequence, LongSupplier cursor, Runnable barrier) throws InterruptedException {
            long availableSequence;
            while ((availableSequence = cursor.getAsLong()) < sequence) {
                barrier.run();
            }
            return availableSequence;
        }
    }

    static final class Blocking
    extends WaitStrategy {
        private final Lock lock = new ReentrantLock();
        private final Condition processorNotifyCondition = this.lock.newCondition();

        Blocking() {
        }

        @Override
        public void signalAllWhenBlocking() {
            this.lock.lock();
            try {
                this.processorNotifyCondition.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long waitFor(long sequence, LongSupplier cursorSequence, Runnable barrier) throws InterruptedException {
            long availableSequence = cursorSequence.getAsLong();
            if (availableSequence < sequence) {
                this.lock.lock();
                try {
                    while ((availableSequence = cursorSequence.getAsLong()) < sequence) {
                        barrier.run();
                        this.processorNotifyCondition.await();
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
            while ((availableSequence = cursorSequence.getAsLong()) < sequence) {
                barrier.run();
            }
            return availableSequence;
        }
    }

    static final class AlertException
    extends RuntimeException {
        public static final AlertException INSTANCE = new AlertException();

        private AlertException() {
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }
}

