/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.handlers;

import java.util.Map;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.async.connection.ChannelAttributes;
import org.neo4j.driver.internal.messaging.BoltProtocolVersion;
import org.neo4j.driver.internal.messaging.v3.BoltProtocolV3;
import org.neo4j.driver.internal.shaded.io.netty.channel.Channel;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelPromise;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.Future;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.GenericFutureListener;
import org.neo4j.driver.internal.spi.ResponseHandler;
import org.neo4j.driver.internal.util.MetadataExtractor;
import org.neo4j.driver.internal.util.ServerVersion;

public class HelloResponseHandler
implements ResponseHandler {
    private static final String CONNECTION_ID_METADATA_KEY = "connection_id";
    private final ChannelPromise connectionInitializedPromise;
    private final Channel channel;
    private final BoltProtocolVersion protocolVersion;

    public HelloResponseHandler(ChannelPromise connectionInitializedPromise, BoltProtocolVersion protocolVersion) {
        this.connectionInitializedPromise = connectionInitializedPromise;
        this.channel = connectionInitializedPromise.channel();
        this.protocolVersion = protocolVersion;
    }

    @Override
    public void onSuccess(Map<String, Value> metadata) {
        try {
            Value serverValue = MetadataExtractor.extractServer(metadata);
            ChannelAttributes.setServerAgent(this.channel, serverValue.asString());
            if (BoltProtocolV3.VERSION.equals(this.protocolVersion)) {
                ChannelAttributes.setServerVersion(this.channel, MetadataExtractor.extractNeo4jServerVersion(metadata));
            } else {
                ChannelAttributes.setServerVersion(this.channel, ServerVersion.fromBoltProtocolVersion(this.protocolVersion));
            }
            String connectionId = HelloResponseHandler.extractConnectionId(metadata);
            ChannelAttributes.setConnectionId(this.channel, connectionId);
            this.connectionInitializedPromise.setSuccess();
        }
        catch (Throwable error) {
            this.onFailure(error);
            throw error;
        }
    }

    @Override
    public void onFailure(Throwable error) {
        this.channel.close().addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> this.connectionInitializedPromise.setFailure(error)));
    }

    @Override
    public void onRecord(Value[] fields) {
        throw new UnsupportedOperationException();
    }

    private static String extractConnectionId(Map<String, Value> metadata) {
        Value value = metadata.get(CONNECTION_ID_METADATA_KEY);
        if (value == null || value.isNull()) {
            throw new IllegalStateException("Unable to extract connection_id from a response to HELLO message. Received metadata: " + metadata);
        }
        return value.asString();
    }
}

