/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.reactor.core.publisher;

import java.util.Objects;
import org.neo4j.driver.internal.shaded.reactor.core.CorePublisher;
import org.neo4j.driver.internal.shaded.reactor.core.CoreSubscriber;
import org.neo4j.driver.internal.shaded.reactor.core.Scannable;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.Mono;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.MonoIgnoreElements;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.OptimizableOperator;
import org.neo4j.driver.internal.shaded.reactor.util.annotation.Nullable;
import org.reactivestreams.Publisher;

final class MonoIgnorePublisher<T>
extends Mono<T>
implements Scannable,
OptimizableOperator<T, T> {
    final Publisher<? extends T> source;
    @Nullable
    final OptimizableOperator<?, T> optimizableOperator;

    MonoIgnorePublisher(Publisher<? extends T> source) {
        this.source = Objects.requireNonNull(source, "publisher");
        this.optimizableOperator = source instanceof OptimizableOperator ? (OptimizableOperator)source : null;
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        this.source.subscribe(this.subscribeOrReturn(actual));
    }

    @Override
    public final CoreSubscriber<? super T> subscribeOrReturn(CoreSubscriber<? super T> actual) {
        return new MonoIgnoreElements.IgnoreElementsSubscriber<T>(actual);
    }

    @Override
    public final CorePublisher<? extends T> source() {
        return this;
    }

    @Override
    public final OptimizableOperator<?, ? extends T> nextOptimizableSource() {
        return this.optimizableOperator;
    }

    @Override
    @Nullable
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.PARENT) {
            return this.source;
        }
        return null;
    }
}

