/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.reactor.core.publisher;

import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.neo4j.driver.internal.shaded.reactor.core.CoreSubscriber;
import org.neo4j.driver.internal.shaded.reactor.core.Fuseable;
import org.neo4j.driver.internal.shaded.reactor.core.Scannable;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.Flux;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.MonoFromFluxOperator;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.Operators;
import org.neo4j.driver.internal.shaded.reactor.util.annotation.Nullable;
import org.reactivestreams.Subscription;

final class MonoCollect<T, R>
extends MonoFromFluxOperator<T, R>
implements Fuseable {
    final Supplier<R> supplier;
    final BiConsumer<? super R, ? super T> action;

    MonoCollect(Flux<? extends T> source, Supplier<R> supplier, BiConsumer<? super R, ? super T> action) {
        super(source);
        this.supplier = Objects.requireNonNull(supplier, "supplier");
        this.action = Objects.requireNonNull(action);
    }

    @Override
    public CoreSubscriber<? super T> subscribeOrReturn(CoreSubscriber<? super R> actual) {
        R container;
        try {
            container = Objects.requireNonNull(this.supplier.get(), "The supplier returned a null container");
        }
        catch (Throwable e) {
            Operators.error(actual, Operators.onOperatorError(e, actual.currentContext()));
            return null;
        }
        return new CollectSubscriber<T, R>(actual, this.action, container);
    }

    static final class CollectSubscriber<T, R>
    extends Operators.MonoSubscriber<T, R> {
        final BiConsumer<? super R, ? super T> action;
        Subscription s;
        boolean done;

        CollectSubscriber(CoreSubscriber<? super R> actual, BiConsumer<? super R, ? super T> action, R container) {
            super(actual);
            this.action = action;
            this.value = container;
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.TERMINATED) {
                return this.done;
            }
            if (key == Scannable.Attr.PARENT) {
                return this.s;
            }
            return super.scanUnsafe(key);
        }

        @Override
        public void cancel() {
            super.cancel();
            this.s.cancel();
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
                s.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t, this.actual.currentContext());
                return;
            }
            try {
                this.action.accept(this.value, t);
            }
            catch (Throwable e) {
                this.onError(Operators.onOperatorError(this, e, t, this.actual.currentContext()));
            }
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t, this.actual.currentContext());
                return;
            }
            this.done = true;
            Object v = this.value;
            Operators.onDiscard(v, this.currentContext());
            this.value = null;
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.complete(this.value);
        }

        @Override
        public void setValue(R value) {
        }
    }
}

