/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.reactive;

import java.util.concurrent.CompletableFuture;
import org.neo4j.driver.Statement;
import org.neo4j.driver.internal.async.ExplicitTransaction;
import org.neo4j.driver.internal.reactive.AbstractRxStatementRunner;
import org.neo4j.driver.internal.reactive.InternalRxStatementResult;
import org.neo4j.driver.internal.reactive.RxUtils;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.reactive.RxStatementResult;
import org.neo4j.driver.reactive.RxTransaction;
import org.reactivestreams.Publisher;

public class InternalRxTransaction
extends AbstractRxStatementRunner
implements RxTransaction {
    private final ExplicitTransaction tx;

    public InternalRxTransaction(ExplicitTransaction tx) {
        this.tx = tx;
    }

    @Override
    public RxStatementResult run(Statement statement) {
        return new InternalRxStatementResult(() -> {
            CompletableFuture cursorFuture = new CompletableFuture();
            this.tx.runRx(statement).whenComplete((cursor, completionError) -> {
                if (cursor != null) {
                    cursorFuture.complete(cursor);
                } else {
                    Throwable error = Futures.completionExceptionCause(completionError);
                    this.tx.markTerminated();
                    cursorFuture.completeExceptionally(error);
                }
            });
            return cursorFuture;
        });
    }

    @Override
    public <T> Publisher<T> commit() {
        return this.close(true);
    }

    @Override
    public <T> Publisher<T> rollback() {
        return this.close(false);
    }

    private <T> Publisher<T> close(boolean commit) {
        return RxUtils.createEmptyPublisher(() -> {
            if (commit) {
                return this.tx.commitAsync();
            }
            return this.tx.rollbackAsync();
        });
    }
}

