/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.reactor.core.publisher;

import java.util.function.Consumer;
import org.neo4j.driver.internal.shaded.reactor.core.CoreSubscriber;
import org.neo4j.driver.internal.shaded.reactor.core.Disposable;
import org.neo4j.driver.internal.shaded.reactor.core.Fuseable;
import org.neo4j.driver.internal.shaded.reactor.core.Scannable;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.AssemblyOp;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.ConnectableFlux;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.FluxOnAssembly;
import org.neo4j.driver.internal.shaded.reactor.util.annotation.Nullable;

final class ConnectableFluxOnAssembly<T>
extends ConnectableFlux<T>
implements Fuseable,
AssemblyOp,
Scannable {
    final ConnectableFlux<T> source;
    final FluxOnAssembly.AssemblySnapshot stacktrace;

    ConnectableFluxOnAssembly(ConnectableFlux<T> source, FluxOnAssembly.AssemblySnapshot stacktrace) {
        this.source = source;
        this.stacktrace = stacktrace;
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        FluxOnAssembly.subscribe(actual, this.source, this.stacktrace);
    }

    @Override
    public void connect(Consumer<? super Disposable> cancelSupport) {
        this.source.connect(cancelSupport);
    }

    @Override
    @Nullable
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.PREFETCH) {
            return this.getPrefetch();
        }
        if (key == Scannable.Attr.PARENT) {
            return this.source;
        }
        if (key == Scannable.Attr.ACTUAL_METADATA) {
            return !this.stacktrace.checkpointed;
        }
        return null;
    }

    @Override
    public String stepName() {
        return this.stacktrace.operatorAssemblyInformation();
    }

    @Override
    public String toString() {
        return this.stacktrace.operatorAssemblyInformation();
    }
}

