/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.handlers;

import java.util.Map;
import java.util.Objects;
import org.neo4j.driver.Statement;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.BookmarkHolder;
import org.neo4j.driver.internal.handlers.AbstractPullAllResponseHandler;
import org.neo4j.driver.internal.handlers.RunResponseHandler;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.util.MetadataExtractor;

public class SessionPullAllResponseHandler
extends AbstractPullAllResponseHandler {
    private final BookmarkHolder bookmarkHolder;

    public SessionPullAllResponseHandler(Statement statement, RunResponseHandler runResponseHandler, Connection connection, BookmarkHolder bookmarkHolder, MetadataExtractor metadataExtractor) {
        super(statement, runResponseHandler, connection, metadataExtractor);
        this.bookmarkHolder = Objects.requireNonNull(bookmarkHolder);
    }

    @Override
    protected void afterSuccess(Map<String, Value> metadata) {
        this.releaseConnection();
        this.bookmarkHolder.setBookmark(MetadataExtractor.extractBookmarks(metadata));
    }

    @Override
    protected void afterFailure(Throwable error) {
        this.releaseConnection();
    }

    private void releaseConnection() {
        this.connection.release();
    }
}

