/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.handlers;

import java.util.concurrent.CompletableFuture;
import org.neo4j.driver.internal.async.connection.ChannelAttributes;
import org.neo4j.driver.internal.async.inbound.InboundMessageDispatcher;
import org.neo4j.driver.internal.handlers.ResetResponseHandler;
import org.neo4j.driver.internal.shaded.io.netty.channel.Channel;
import org.neo4j.driver.internal.shaded.io.netty.channel.pool.ChannelPool;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.Future;
import org.neo4j.driver.internal.util.Clock;

public class ChannelReleasingResetResponseHandler
extends ResetResponseHandler {
    private final Channel channel;
    private final ChannelPool pool;
    private final Clock clock;

    public ChannelReleasingResetResponseHandler(Channel channel, ChannelPool pool, InboundMessageDispatcher messageDispatcher, Clock clock, CompletableFuture<Void> releaseFuture) {
        super(messageDispatcher, releaseFuture);
        this.channel = channel;
        this.pool = pool;
        this.clock = clock;
    }

    @Override
    protected void resetCompleted(CompletableFuture<Void> completionFuture, boolean success) {
        if (success) {
            ChannelAttributes.setLastUsedTimestamp(this.channel, this.clock.millis());
        } else {
            this.channel.close();
        }
        Future<Void> released = this.pool.release(this.channel);
        released.addListener(ignore -> completionFuture.complete(null));
    }
}

