/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Statement;
import org.neo4j.driver.TransactionConfig;
import org.neo4j.driver.async.AsyncSession;
import org.neo4j.driver.async.AsyncTransaction;
import org.neo4j.driver.async.AsyncTransactionWork;
import org.neo4j.driver.async.StatementResultCursor;
import org.neo4j.driver.internal.Bookmark;
import org.neo4j.driver.internal.async.AsyncAbstractStatementRunner;
import org.neo4j.driver.internal.async.ExplicitTransaction;
import org.neo4j.driver.internal.async.InternalAsyncTransaction;
import org.neo4j.driver.internal.async.NetworkSession;
import org.neo4j.driver.internal.util.Futures;

public class InternalAsyncSession
extends AsyncAbstractStatementRunner
implements AsyncSession {
    private final NetworkSession session;

    public InternalAsyncSession(NetworkSession session) {
        this.session = session;
    }

    @Override
    public CompletionStage<StatementResultCursor> runAsync(Statement statement) {
        return this.runAsync(statement, TransactionConfig.empty());
    }

    @Override
    public CompletionStage<StatementResultCursor> runAsync(String statement, TransactionConfig config) {
        return this.runAsync(statement, Collections.emptyMap(), config);
    }

    @Override
    public CompletionStage<StatementResultCursor> runAsync(String statement, Map<String, Object> parameters, TransactionConfig config) {
        return this.runAsync(new Statement(statement, parameters), config);
    }

    @Override
    public CompletionStage<StatementResultCursor> runAsync(Statement statement, TransactionConfig config) {
        return this.session.runAsync(statement, config, true);
    }

    @Override
    public CompletionStage<Void> closeAsync() {
        return this.session.closeAsync();
    }

    @Override
    public CompletionStage<AsyncTransaction> beginTransactionAsync() {
        return this.beginTransactionAsync(TransactionConfig.empty());
    }

    @Override
    public CompletionStage<AsyncTransaction> beginTransactionAsync(TransactionConfig config) {
        return this.session.beginTransactionAsync(config).thenApply(InternalAsyncTransaction::new);
    }

    @Override
    public <T> CompletionStage<T> readTransactionAsync(AsyncTransactionWork<CompletionStage<T>> work) {
        return this.readTransactionAsync(work, TransactionConfig.empty());
    }

    @Override
    public <T> CompletionStage<T> readTransactionAsync(AsyncTransactionWork<CompletionStage<T>> work, TransactionConfig config) {
        return this.transactionAsync(AccessMode.READ, work, config);
    }

    @Override
    public <T> CompletionStage<T> writeTransactionAsync(AsyncTransactionWork<CompletionStage<T>> work) {
        return this.writeTransactionAsync(work, TransactionConfig.empty());
    }

    @Override
    public <T> CompletionStage<T> writeTransactionAsync(AsyncTransactionWork<CompletionStage<T>> work, TransactionConfig config) {
        return this.transactionAsync(AccessMode.WRITE, work, config);
    }

    @Override
    public Bookmark lastBookmark() {
        return this.session.lastBookmark();
    }

    private <T> CompletionStage<T> transactionAsync(AccessMode mode, AsyncTransactionWork<CompletionStage<T>> work, TransactionConfig config) {
        return this.session.retryLogic().retryAsync(() -> {
            CompletableFuture resultFuture = new CompletableFuture();
            CompletionStage<ExplicitTransaction> txFuture = this.session.beginTransactionAsync(mode, config);
            txFuture.whenComplete((tx, completionError) -> {
                Throwable error = Futures.completionExceptionCause(completionError);
                if (error != null) {
                    resultFuture.completeExceptionally(error);
                } else {
                    this.executeWork(resultFuture, (ExplicitTransaction)tx, work);
                }
            });
            return resultFuture;
        });
    }

    private <T> void executeWork(CompletableFuture<T> resultFuture, ExplicitTransaction tx, AsyncTransactionWork<CompletionStage<T>> work) {
        CompletionStage<Object> workFuture = this.safeExecuteWork(tx, work);
        workFuture.whenComplete((result, completionError) -> {
            Throwable error = Futures.completionExceptionCause(completionError);
            if (error != null) {
                this.rollbackTxAfterFailedTransactionWork(tx, resultFuture, error);
            } else {
                this.closeTxAfterSucceededTransactionWork(tx, resultFuture, result);
            }
        });
    }

    private <T> CompletionStage<T> safeExecuteWork(ExplicitTransaction tx, AsyncTransactionWork<CompletionStage<T>> work) {
        try {
            CompletionStage<T> result = work.execute(new InternalAsyncTransaction(tx));
            return result == null ? Futures.completedWithNull() : result;
        }
        catch (Throwable workError) {
            return Futures.failedFuture(workError);
        }
    }

    private <T> void rollbackTxAfterFailedTransactionWork(ExplicitTransaction tx, CompletableFuture<T> resultFuture, Throwable error) {
        if (tx.isOpen()) {
            tx.rollbackAsync().whenComplete((ignore, rollbackError) -> {
                if (rollbackError != null) {
                    error.addSuppressed((Throwable)rollbackError);
                }
                resultFuture.completeExceptionally(error);
            });
        } else {
            resultFuture.completeExceptionally(error);
        }
    }

    private <T> void closeTxAfterSucceededTransactionWork(ExplicitTransaction tx, CompletableFuture<T> resultFuture, T result) {
        if (tx.isOpen()) {
            tx.success();
            tx.closeAsync().whenComplete((ignore, completionError) -> {
                Throwable commitError = Futures.completionExceptionCause(completionError);
                if (commitError != null) {
                    resultFuture.completeExceptionally(commitError);
                } else {
                    resultFuture.complete(result);
                }
            });
        } else {
            resultFuture.complete(result);
        }
    }
}

