/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.internal.Bookmark;

public class SessionConfig {
    private static final SessionConfig EMPTY = SessionConfig.builder().build();
    private final Iterable<Bookmark> bookmarks;
    private final AccessMode defaultAccessMode;
    private final String database;

    private SessionConfig(Builder builder) {
        this.bookmarks = builder.bookmarks;
        this.defaultAccessMode = builder.defaultAccessMode;
        this.database = builder.database;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static SessionConfig defaultConfig() {
        return EMPTY;
    }

    public static SessionConfig forDatabase(String database) {
        return new Builder().withDatabase(database).build();
    }

    public Iterable<Bookmark> bookmarks() {
        return this.bookmarks;
    }

    public AccessMode defaultAccessMode() {
        return this.defaultAccessMode;
    }

    public Optional<String> database() {
        return Optional.ofNullable(this.database);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionConfig that = (SessionConfig)o;
        return Objects.equals(this.bookmarks, that.bookmarks) && this.defaultAccessMode == that.defaultAccessMode && this.database.equals(that.database);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.bookmarks, this.defaultAccessMode, this.database});
    }

    public String toString() {
        return "SessionParameters{bookmarks=" + this.bookmarks + ", defaultAccessMode=" + (Object)((Object)this.defaultAccessMode) + ", database='" + this.database + '\'' + '}';
    }

    public static class Builder {
        private Iterable<Bookmark> bookmarks = null;
        private AccessMode defaultAccessMode = AccessMode.WRITE;
        private String database = null;

        private Builder() {
        }

        public Builder withBookmarks(Bookmark ... bookmarks) {
            this.bookmarks = bookmarks == null ? null : Arrays.asList(bookmarks);
            return this;
        }

        public Builder withBookmarks(Iterable<Bookmark> bookmarks) {
            this.bookmarks = bookmarks;
            return this;
        }

        public Builder withDefaultAccessMode(AccessMode mode) {
            this.defaultAccessMode = mode;
            return this;
        }

        public Builder withDatabase(String database) {
            Objects.requireNonNull(database, "Database name should not be null.");
            if ("".equals(database)) {
                throw new IllegalArgumentException(String.format("Illegal database name '%s'.", database));
            }
            this.database = database.toLowerCase();
            return this;
        }

        public SessionConfig build() {
            return new SessionConfig(this);
        }
    }
}

