/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.Collections;
import java.util.Map;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Session;
import org.neo4j.driver.Statement;
import org.neo4j.driver.StatementResult;
import org.neo4j.driver.Transaction;
import org.neo4j.driver.TransactionConfig;
import org.neo4j.driver.TransactionWork;
import org.neo4j.driver.async.StatementResultCursor;
import org.neo4j.driver.internal.AbstractStatementRunner;
import org.neo4j.driver.internal.InternalStatementResult;
import org.neo4j.driver.internal.InternalTransaction;
import org.neo4j.driver.internal.async.ExplicitTransaction;
import org.neo4j.driver.internal.async.NetworkSession;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.util.Futures;

public class InternalSession
extends AbstractStatementRunner
implements Session {
    private final NetworkSession session;

    public InternalSession(NetworkSession session) {
        this.session = session;
    }

    @Override
    public StatementResult run(Statement statement) {
        return this.run(statement, TransactionConfig.empty());
    }

    @Override
    public StatementResult run(String statement, TransactionConfig config) {
        return this.run(statement, Collections.emptyMap(), config);
    }

    @Override
    public StatementResult run(String statement, Map<String, Object> parameters, TransactionConfig config) {
        return this.run(new Statement(statement, parameters), config);
    }

    @Override
    public StatementResult run(Statement statement, TransactionConfig config) {
        StatementResultCursor cursor = Futures.blockingGet(this.session.runAsync(statement, config, false), () -> this.terminateConnectionOnThreadInterrupt("Thread interrupted while running query in session"));
        Connection connection = Futures.getNow(this.session.connectionAsync());
        return new InternalStatementResult(connection, cursor);
    }

    @Override
    public boolean isOpen() {
        return this.session.isOpen();
    }

    @Override
    public void close() {
        Futures.blockingGet(this.session.closeAsync(), () -> this.terminateConnectionOnThreadInterrupt("Thread interrupted while closing the session"));
    }

    @Override
    public Transaction beginTransaction() {
        return this.beginTransaction(TransactionConfig.empty());
    }

    @Override
    public Transaction beginTransaction(TransactionConfig config) {
        ExplicitTransaction tx = Futures.blockingGet(this.session.beginTransactionAsync(config), () -> this.terminateConnectionOnThreadInterrupt("Thread interrupted while starting a transaction"));
        return new InternalTransaction(tx);
    }

    @Override
    public <T> T readTransaction(TransactionWork<T> work) {
        return this.readTransaction(work, TransactionConfig.empty());
    }

    @Override
    public <T> T readTransaction(TransactionWork<T> work, TransactionConfig config) {
        return this.transaction(AccessMode.READ, work, config);
    }

    @Override
    public <T> T writeTransaction(TransactionWork<T> work) {
        return this.writeTransaction(work, TransactionConfig.empty());
    }

    @Override
    public <T> T writeTransaction(TransactionWork<T> work, TransactionConfig config) {
        return this.transaction(AccessMode.WRITE, work, config);
    }

    @Override
    public String lastBookmark() {
        return this.session.lastBookmark();
    }

    @Override
    public void reset() {
        Futures.blockingGet(this.session.resetAsync(), () -> this.terminateConnectionOnThreadInterrupt("Thread interrupted while resetting the session"));
    }

    private <T> T transaction(AccessMode mode, TransactionWork<T> work, TransactionConfig config) {
        return (T)this.session.retryLogic().retry(() -> {
            Throwable throwable = null;
            try (Transaction tx = this.beginTransaction(mode, config);){
                Object result = work.execute(tx);
                tx.success();
                Object t = result;
                return t;
            }
            catch (Throwable t) {
                try {
                    tx.failure();
                    throw t;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        });
    }

    private Transaction beginTransaction(AccessMode mode, TransactionConfig config) {
        ExplicitTransaction tx = Futures.blockingGet(this.session.beginTransactionAsync(mode, config), () -> this.terminateConnectionOnThreadInterrupt("Thread interrupted while starting a transaction"));
        return new InternalTransaction(tx);
    }

    private void terminateConnectionOnThreadInterrupt(String reason) {
        Connection connection = null;
        try {
            connection = Futures.getNow(this.session.connectionAsync());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (connection != null) {
            connection.terminateAndRelease(reason);
        }
    }
}

