/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.util;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Session;

public class ServerVersion {
    public static final String NEO4J_PRODUCT = "Neo4j";
    public static final ServerVersion v4_0_0 = new ServerVersion("Neo4j", 4, 0, 0);
    public static final ServerVersion v3_5_0 = new ServerVersion("Neo4j", 3, 5, 0);
    public static final ServerVersion v3_4_0 = new ServerVersion("Neo4j", 3, 4, 0);
    public static final ServerVersion v3_2_0 = new ServerVersion("Neo4j", 3, 2, 0);
    public static final ServerVersion v3_1_0 = new ServerVersion("Neo4j", 3, 1, 0);
    public static final ServerVersion v3_0_0 = new ServerVersion("Neo4j", 3, 0, 0);
    public static final ServerVersion vInDev = new ServerVersion("Neo4j", Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    private static final String NEO4J_IN_DEV_VERSION_STRING = "Neo4j/dev";
    private static final Pattern PATTERN = Pattern.compile("([^/]+)/(\\d+)\\.(\\d+)(?:\\.)?(\\d*)(\\.|-|\\+)?([0-9A-Za-z-.]*)?");
    private final String product;
    private final int major;
    private final int minor;
    private final int patch;
    private final String stringValue;

    private ServerVersion(String product, int major, int minor, int patch) {
        this.product = product;
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.stringValue = ServerVersion.stringValue(product, major, minor, patch);
    }

    public String product() {
        return this.product;
    }

    public static ServerVersion version(Driver driver) {
        try (Session session = driver.session();){
            String versionString = session.readTransaction(tx -> tx.run("RETURN 1").consume().server().version());
            ServerVersion serverVersion = ServerVersion.version(versionString);
            return serverVersion;
        }
    }

    public static ServerVersion version(String server) {
        Matcher matcher = PATTERN.matcher(server);
        if (matcher.matches()) {
            String product = matcher.group(1);
            int major = Integer.valueOf(matcher.group(2));
            int minor = Integer.valueOf(matcher.group(3));
            String patchString = matcher.group(4);
            int patch = 0;
            if (patchString != null && !patchString.isEmpty()) {
                patch = Integer.valueOf(patchString);
            }
            return new ServerVersion(product, major, minor, patch);
        }
        if (server.equalsIgnoreCase(NEO4J_IN_DEV_VERSION_STRING)) {
            return vInDev;
        }
        throw new IllegalArgumentException("Cannot parse " + server);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerVersion that = (ServerVersion)o;
        if (!this.product.equals(that.product)) {
            return false;
        }
        if (this.major != that.major) {
            return false;
        }
        if (this.minor != that.minor) {
            return false;
        }
        return this.patch == that.patch;
    }

    public int hashCode() {
        return Objects.hash(this.product, this.major, this.minor, this.patch);
    }

    public boolean greaterThan(ServerVersion other) {
        return this.compareTo(other) > 0;
    }

    public boolean greaterThanOrEqual(ServerVersion other) {
        return this.compareTo(other) >= 0;
    }

    public boolean lessThan(ServerVersion other) {
        return this.compareTo(other) < 0;
    }

    public boolean lessThanOrEqual(ServerVersion other) {
        return this.compareTo(other) <= 0;
    }

    private int compareTo(ServerVersion o) {
        if (!this.product.equals(o.product)) {
            throw new IllegalArgumentException("Comparing different products '" + this.product + "' with '" + o.product + "'");
        }
        int c = Integer.compare(this.major, o.major);
        if (c == 0 && (c = Integer.compare(this.minor, o.minor)) == 0) {
            c = Integer.compare(this.patch, o.patch);
        }
        return c;
    }

    public String toString() {
        return this.stringValue;
    }

    private static String stringValue(String product, int major, int minor, int patch) {
        if (major == Integer.MAX_VALUE && minor == Integer.MAX_VALUE && patch == Integer.MAX_VALUE) {
            return NEO4J_IN_DEV_VERSION_STRING;
        }
        return String.format("%s/%s.%s.%s", product, major, minor, patch);
    }
}

