/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cluster;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.cluster.AddressSet;
import org.neo4j.driver.internal.cluster.ClusterComposition;
import org.neo4j.driver.internal.cluster.RoutingTable;
import org.neo4j.driver.internal.util.Clock;

public class ClusterRoutingTable
implements RoutingTable {
    private static final int MIN_ROUTERS = 1;
    private final Clock clock;
    private volatile long expirationTimeout;
    private final AddressSet readers;
    private final AddressSet writers;
    private final AddressSet routers;

    public ClusterRoutingTable(Clock clock, BoltServerAddress ... routingAddresses) {
        this(clock);
        this.routers.update(new LinkedHashSet<BoltServerAddress>(Arrays.asList(routingAddresses)));
    }

    private ClusterRoutingTable(Clock clock) {
        this.clock = clock;
        this.expirationTimeout = clock.millis() - 1L;
        this.readers = new AddressSet();
        this.writers = new AddressSet();
        this.routers = new AddressSet();
    }

    @Override
    public boolean isStaleFor(AccessMode mode) {
        return this.expirationTimeout < this.clock.millis() || this.routers.size() < 1 || mode == AccessMode.READ && this.readers.size() == 0 || mode == AccessMode.WRITE && this.writers.size() == 0;
    }

    @Override
    public synchronized void update(ClusterComposition cluster) {
        this.expirationTimeout = cluster.expirationTimestamp();
        this.readers.update(cluster.readers());
        this.writers.update(cluster.writers());
        this.routers.update(cluster.routers());
    }

    @Override
    public synchronized void forget(BoltServerAddress address) {
        this.routers.remove(address);
        this.readers.remove(address);
        this.writers.remove(address);
    }

    @Override
    public AddressSet readers() {
        return this.readers;
    }

    @Override
    public AddressSet writers() {
        return this.writers;
    }

    @Override
    public AddressSet routers() {
        return this.routers;
    }

    @Override
    public Set<BoltServerAddress> servers() {
        HashSet<BoltServerAddress> servers = new HashSet<BoltServerAddress>();
        Collections.addAll(servers, this.readers.toArray());
        Collections.addAll(servers, this.writers.toArray());
        Collections.addAll(servers, this.routers.toArray());
        return servers;
    }

    @Override
    public void removeWriter(BoltServerAddress toRemove) {
        this.writers.remove(toRemove);
    }

    public synchronized String toString() {
        return String.format("Ttl %s, currentTime %s, routers %s, writers %s, readers %s", this.expirationTimeout, this.clock.millis(), this.routers, this.writers, this.readers);
    }
}

